/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.jstl.core.Config;
import jakarta.servlet.jsp.jstl.fmt.LocalizationContext;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.BundleSupport;
import org.apache.taglibs.standard.tag.common.fmt.LocaleUtil;

public abstract class SetLocaleSupport
extends TagSupport {
    protected Object value;
    protected String variant;
    private int scope;
    static Locale[] availableFormattingLocales;

    public SetLocaleSupport() {
        this.init();
    }

    private void init() {
        this.variant = null;
        this.value = null;
        this.scope = 1;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    public int doEndTag() throws JspException {
        Locale locale = this.value instanceof Locale ? (Locale)this.value : (this.value instanceof String && !"".equals(((String)this.value).trim()) ? LocaleUtil.parseLocale((String)this.value, this.variant) : Locale.getDefault());
        Config.set(this.pageContext, "jakarta.servlet.jsp.jstl.fmt.locale", locale, this.scope);
        SetLocaleSupport.setResponseLocale(this.pageContext, locale);
        return 6;
    }

    public void release() {
        this.init();
    }

    static void setResponseLocale(PageContext pc, Locale locale) {
        ServletResponse response = pc.getResponse();
        response.setLocale(locale);
        if (pc.getSession() != null) {
            try {
                pc.setAttribute("jakarta.servlet.jsp.jstl.fmt.request.charset", response.getCharacterEncoding(), 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static Locale getFormattingLocale(PageContext pc, Tag fromTag, boolean format, Locale[] avail) {
        LocalizationContext locCtxt;
        Tag parent = SetLocaleSupport.findAncestorWithClass(fromTag, BundleSupport.class);
        if (parent != null && (locCtxt = ((BundleSupport)parent).getLocalizationContext()).getLocale() != null) {
            if (format) {
                SetLocaleSupport.setResponseLocale(pc, locCtxt.getLocale());
            }
            return locCtxt.getLocale();
        }
        locCtxt = BundleSupport.getLocalizationContext(pc);
        if (locCtxt != null && locCtxt.getLocale() != null) {
            if (format) {
                SetLocaleSupport.setResponseLocale(pc, locCtxt.getLocale());
            }
            return locCtxt.getLocale();
        }
        Locale pref = SetLocaleSupport.getLocale(pc, "jakarta.servlet.jsp.jstl.fmt.locale");
        Locale match = pref != null ? SetLocaleSupport.findFormattingMatch(pref, avail) : SetLocaleSupport.findFormattingMatch(pc, avail);
        if (match == null && (pref = SetLocaleSupport.getLocale(pc, "jakarta.servlet.jsp.jstl.fmt.fallbackLocale")) != null) {
            match = SetLocaleSupport.findFormattingMatch(pref, avail);
        }
        if (format && match != null) {
            SetLocaleSupport.setResponseLocale(pc, match);
        }
        return match;
    }

    static Locale getFormattingLocale(PageContext pc) {
        Locale pref = SetLocaleSupport.getLocale(pc, "jakarta.servlet.jsp.jstl.fmt.locale");
        Locale match = pref != null ? SetLocaleSupport.findFormattingMatch(pref, availableFormattingLocales) : SetLocaleSupport.findFormattingMatch(pc, availableFormattingLocales);
        if (match == null && (pref = SetLocaleSupport.getLocale(pc, "jakarta.servlet.jsp.jstl.fmt.fallbackLocale")) != null) {
            match = SetLocaleSupport.findFormattingMatch(pref, availableFormattingLocales);
        }
        if (match != null) {
            SetLocaleSupport.setResponseLocale(pc, match);
        }
        return match;
    }

    static Locale getLocale(PageContext pageContext, String name) {
        Locale loc = null;
        Object obj = Config.find(pageContext, name);
        if (obj != null) {
            loc = obj instanceof Locale ? (Locale)obj : LocaleUtil.parseLocale((String)obj);
        }
        return loc;
    }

    private static Locale findFormattingMatch(PageContext pageContext, Locale[] avail) {
        Locale locale;
        Locale match = null;
        Enumeration enum_ = Util.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enum_.hasMoreElements() && (match = SetLocaleSupport.findFormattingMatch(locale = (Locale)enum_.nextElement(), avail)) == null) {
        }
        return match;
    }

    private static Locale findFormattingMatch(Locale pref, Locale[] avail) {
        Locale match = null;
        boolean langAndCountryMatch = false;
        for (Locale locale : avail) {
            if (pref.equals(locale)) {
                match = locale;
                break;
            }
            if (!"".equals(pref.getVariant()) && "".equals(locale.getVariant()) && pref.getLanguage().equals(locale.getLanguage()) && pref.getCountry().equals(locale.getCountry())) {
                match = locale;
                langAndCountryMatch = true;
                continue;
            }
            if (langAndCountryMatch || !pref.getLanguage().equals(locale.getLanguage()) || !"".equals(locale.getCountry()) || match != null) continue;
            match = locale;
        }
        return match;
    }

    static {
        Locale[] dateLocales = DateFormat.getAvailableLocales();
        Locale[] numberLocales = NumberFormat.getAvailableLocales();
        ArrayList<Locale> locales = new ArrayList<Locale>(dateLocales.length);
        block0: for (Locale dateLocale : dateLocales) {
            for (Locale numberLocale : numberLocales) {
                if (!dateLocale.equals(numberLocale)) continue;
                locales.add(dateLocale);
                continue block0;
            }
        }
        availableFormattingLocales = locales.toArray(new Locale[locales.size()]);
    }
}

