/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server;

import javax.servlet.ServletContext;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.core.WebSocketComponents;

public class WebSocketServerComponents
extends WebSocketComponents {
    public static final String WEBSOCKET_COMPONENTS_ATTRIBUTE = WebSocketComponents.class.getName();
    public static final String WEBSOCKET_INFLATER_POOL_ATTRIBUTE = "jetty.websocket.inflater";
    public static final String WEBSOCKET_DEFLATER_POOL_ATTRIBUTE = "jetty.websocket.deflater";

    WebSocketServerComponents(InflaterPool inflaterPool, DeflaterPool deflaterPool) {
        super(null, null, null, inflaterPool, deflaterPool);
    }

    public static WebSocketComponents ensureWebSocketComponents(Server server, ServletContext servletContext) {
        WebSocketComponents components = server.getBean(WebSocketComponents.class);
        if (components == null) {
            DeflaterPool deflaterPool;
            InflaterPool inflaterPool = (InflaterPool)servletContext.getAttribute(WEBSOCKET_INFLATER_POOL_ATTRIBUTE);
            if (inflaterPool == null) {
                inflaterPool = InflaterPool.ensurePool(server);
            }
            if ((deflaterPool = (DeflaterPool)servletContext.getAttribute(WEBSOCKET_DEFLATER_POOL_ATTRIBUTE)) == null) {
                deflaterPool = DeflaterPool.ensurePool(server);
            }
            components = new WebSocketServerComponents(inflaterPool, deflaterPool);
            server.addBean(components);
        }
        servletContext.setAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE, components);
        return components;
    }

    public static WebSocketComponents getWebSocketComponents(ServletContext servletContext) {
        WebSocketComponents components = (WebSocketComponents)servletContext.getAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
        if (components == null) {
            throw new IllegalStateException("WebSocketComponents has not been created");
        }
        return components;
    }
}

