/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public class InMemoryCompiler {
    private List<String> options;

    public InMemoryCompiler setSourceTarget(String source, String target) {
        this.options = Arrays.asList("-source", source, "-target", target, "-classpath", "");
        return this;
    }

    public Collection<Unit> compile(Collection<Unit> units) {
        HashMap<String, OutputFileObject> outputs = new HashMap<String, OutputFileObject>();
        ArrayList sources = new ArrayList();
        units.forEach(unit -> {
            outputs.put(unit.classname, new OutputFileObject(unit.classname));
            sources.add(new UnitFileObject((Unit)unit));
        });
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        CustomFileManager javaFileManager = new CustomFileManager(compiler.getStandardFileManager(null, null, null), outputs);
        if (!compiler.getTask(null, javaFileManager, null, this.options, null, sources).call().booleanValue()) {
            throw new RuntimeException("Compilation failed");
        }
        ArrayList<Unit> ret = new ArrayList<Unit>();
        units.forEach(unit -> {
            unit.bytecode = ((OutputFileObject)outputs.get(unit.classname)).getBytes();
            ret.add((Unit)unit);
        });
        return ret;
    }

    private static class CustomFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final Map<String, OutputFileObject> outputs;

        CustomFileManager(JavaFileManager jfm, Map<String, OutputFileObject> outputs) {
            super(jfm);
            this.outputs = outputs;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location loc, String name, JavaFileObject.Kind kind, FileObject sibling) {
            OutputFileObject output = this.outputs.get(name);
            return output;
        }
    }

    private static class OutputFileObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public OutputFileObject(String className) {
            super(URI.create(className), JavaFileObject.Kind.CLASS);
        }

        @Override
        public OutputStream openOutputStream() {
            return this.baos;
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }

    private static class UnitFileObject
    extends SimpleJavaFileObject {
        private final Unit unit;

        public UnitFileObject(Unit unit) {
            super(URI.create("string:///" + unit.getSourceFilename()), JavaFileObject.Kind.SOURCE);
            this.unit = unit;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.unit.source;
        }
    }

    public static class Unit {
        public String classname;
        public String source;
        public byte[] bytecode;

        public Unit() {
        }

        public Unit(String name, String source) {
            this.classname = name;
            this.source = source;
        }

        public String getSourceFilename() {
            return this.classname.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension;
        }

        public String getClassFilename() {
            return this.classname.replace('.', '/') + JavaFileObject.Kind.CLASS.extension;
        }
    }
}

