/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.util;

import java.util.BitSet;

public class UrlUtil {
    private static final BitSet VALID_SCHEME_CHARS = new BitSet(128);

    public static boolean isAbsoluteUrl(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(":");
        if (colonPos == -1) {
            return false;
        }
        for (int i2 = 0; i2 < colonPos; ++i2) {
            if (VALID_SCHEME_CHARS.get(url.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String getScheme(CharSequence url) {
        StringBuilder scheme = new StringBuilder();
        for (int i2 = 0; i2 < url.length(); ++i2) {
            String result;
            char ch = url.charAt(i2);
            if (ch == ':' && !"jar".equals(result = scheme.toString())) {
                return result;
            }
            scheme.append(ch);
        }
        throw new IllegalArgumentException("No scheme found: " + url);
    }

    static {
        VALID_SCHEME_CHARS.set(65, 91);
        VALID_SCHEME_CHARS.set(97, 123);
        VALID_SCHEME_CHARS.set(48, 58);
        VALID_SCHEME_CHARS.set(43);
        VALID_SCHEME_CHARS.set(46);
        VALID_SCHEME_CHARS.set(45);
    }
}

