/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.util.messages;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.util.InvalidSignatureException;
import org.eclipse.jetty.websocket.util.messages.AbstractMessageSink;

public class PartialByteArrayMessageSink
extends AbstractMessageSink {
    private static byte[] EMPTY_BUFFER = new byte[0];

    public PartialByteArrayMessageSink(CoreSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
        MethodType onMessageType = MethodType.methodType(Void.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        if (methodHandle.type() != onMessageType) {
            throw InvalidSignatureException.build(onMessageType, methodHandle.type());
        }
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            if (frame.hasPayload() || frame.isFin()) {
                byte[] buffer = frame.hasPayload() ? BufferUtil.toArray(frame.getPayload()) : EMPTY_BUFFER;
                this.methodHandle.invoke(buffer, 0, buffer.length, frame.isFin());
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
    }
}

