/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core;

import javax.servlet.ServletContext;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;

public class WebSocketComponents {
    public static final String WEBSOCKET_COMPONENTS_ATTRIBUTE = WebSocketComponents.class.getName();
    private DecoratedObjectFactory objectFactory;
    private WebSocketExtensionRegistry extensionRegistry;
    private ByteBufferPool bufferPool;
    private InflaterPool inflaterPool;
    private DeflaterPool deflaterPool;

    public static WebSocketComponents ensureWebSocketComponents(ServletContext servletContext) {
        WebSocketComponents components = (WebSocketComponents)servletContext.getAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
        if (components == null) {
            components = new WebSocketComponents();
            servletContext.setAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE, components);
        }
        return components;
    }

    public WebSocketComponents() {
        this(new WebSocketExtensionRegistry(), new DecoratedObjectFactory(), new MappedByteBufferPool(), new InflaterPool(-1, true), new DeflaterPool(-1, -1, true));
    }

    public WebSocketComponents(WebSocketExtensionRegistry extensionRegistry, DecoratedObjectFactory objectFactory, ByteBufferPool bufferPool, InflaterPool inflaterPool, DeflaterPool deflaterPool) {
        this.extensionRegistry = extensionRegistry;
        this.objectFactory = objectFactory;
        this.bufferPool = bufferPool;
        this.deflaterPool = deflaterPool;
        this.inflaterPool = inflaterPool;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public WebSocketExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }
}

