/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketSessionListener;

public class SessionTracker
extends AbstractLifeCycle
implements WebSocketSessionListener {
    private List<Session> sessions = new CopyOnWriteArrayList<Session>();

    public Collection<Session> getSessions() {
        return this.sessions;
    }

    @Override
    public void onWebSocketSessionOpened(Session session) {
        this.sessions.add(session);
    }

    @Override
    public void onWebSocketSessionClosed(Session session) {
        this.sessions.remove(session);
    }

    @Override
    protected void doStop() throws Exception {
        for (Session session : this.sessions) {
            session.close(1001, "Container being shut down");
        }
        super.doStop();
    }
}

