/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client;

import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.core.client.XmlHttpClientProvider;

public interface HttpClientProvider {
    public static HttpClient get() {
        try {
            XmlHttpClientProvider xmlProvider = new XmlHttpClientProvider();
            HttpClient client = xmlProvider.newHttpClient();
            if (client != null) {
                return client;
            }
        }
        catch (Throwable x) {
            Log.getLogger(HttpClientProvider.class).ignore(x);
        }
        return HttpClientProvider.newDefaultHttpClient();
    }

    private static HttpClient newDefaultHttpClient() {
        HttpClient client = new HttpClient();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("WebSocketClient@" + client.hashCode());
        client.setExecutor((Executor)threadPool);
        return client;
    }

    default public HttpClient newHttpClient() {
        return HttpClientProvider.newDefaultHttpClient();
    }
}

