/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal.compress;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.BadPayloadException;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.ProtocolException;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.internal.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.core.internal.compress.CompressExtension;

public class PerMessageDeflateExtension
extends CompressExtension {
    private static final Logger LOG = Log.getLogger(PerMessageDeflateExtension.class);
    private ExtensionConfig configRequested;
    private ExtensionConfig configNegotiated;
    private boolean incomingContextTakeover = true;
    private boolean outgoingContextTakeover = true;
    private boolean incomingCompressed;

    @Override
    public String getName() {
        return "permessage-deflate";
    }

    @Override
    public void onFrame(Frame frame, Callback callback) {
        switch (frame.getOpCode()) {
            case 1: 
            case 2: {
                this.incomingCompressed = frame.isRsv1();
                break;
            }
            case 0: {
                if (!frame.isRsv1()) break;
                callback.failed(new ProtocolException("Invalid RSV1 set on permessage-deflate CONTINUATION frame"));
                break;
            }
        }
        if (OpCode.isControlFrame(frame.getOpCode()) || !this.incomingCompressed) {
            this.nextIncomingFrame(frame, callback);
            return;
        }
        if (this.getWebSocketCoreSession().getMaxFrameSize() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maxFrameSize too large for ByteAccumulator");
        }
        ByteAccumulator accumulator = new ByteAccumulator((int)this.getWebSocketCoreSession().getMaxFrameSize());
        try {
            ByteBuffer payload = frame.getPayload();
            this.decompress(accumulator, payload);
            if (frame.isFin()) {
                this.decompress(accumulator, TAIL_BYTES_BUF.slice());
            }
            this.forwardIncoming(frame, callback, accumulator);
        }
        catch (DataFormatException e) {
            throw new BadPayloadException(e);
        }
        if (frame.isFin()) {
            this.incomingCompressed = false;
        }
    }

    @Override
    protected void nextIncomingFrame(Frame frame, Callback callback) {
        if (frame.isFin() && !this.incomingContextTakeover) {
            LOG.debug("Incoming Context Reset", new Object[0]);
            this.decompressCount.set(0);
            this.releaseInflater();
        }
        super.nextIncomingFrame(frame, callback);
    }

    @Override
    protected void nextOutgoingFrame(Frame frame, Callback callback, boolean batch) {
        if (frame.isFin() && !this.outgoingContextTakeover) {
            LOG.debug("Outgoing Context Reset", new Object[0]);
            this.releaseDeflater();
        }
        super.nextOutgoingFrame(frame, callback, batch);
    }

    @Override
    int getRsvUseMode() {
        return 1;
    }

    @Override
    int getTailDropMode() {
        return 2;
    }

    @Override
    public void init(ExtensionConfig config, WebSocketComponents components) {
        this.configRequested = new ExtensionConfig(config);
        HashMap<String, String> paramsNegotiated = new HashMap<String, String>();
        block11: for (String key : config.getParameterKeys()) {
            switch (key = key.trim()) {
                case "client_max_window_bits": 
                case "server_max_window_bits": {
                    continue block11;
                }
                case "client_no_context_takeover": {
                    paramsNegotiated.put("client_no_context_takeover", null);
                    this.incomingContextTakeover = false;
                    continue block11;
                }
                case "server_no_context_takeover": {
                    paramsNegotiated.put("server_no_context_takeover", null);
                    this.outgoingContextTakeover = false;
                    continue block11;
                }
            }
            throw new IllegalArgumentException();
        }
        this.configNegotiated = new ExtensionConfig(config.getName(), paramsNegotiated);
        LOG.debug("config: outgoingContextTakover={}, incomingContextTakeover={} : {}", this.outgoingContextTakeover, this.incomingContextTakeover, this);
        super.init(this.configNegotiated, components);
    }

    @Override
    public String toString() {
        return String.format("%s[requested=\"%s\", negotiated=\"%s\"]", this.getClass().getSimpleName(), this.configRequested.getParameterizedName(), this.configNegotiated.getParameterizedName());
    }
}

