/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal.compress;

import java.util.zip.DataFormatException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.BadPayloadException;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.internal.WebSocketCoreSession;
import org.eclipse.jetty.websocket.core.internal.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.core.internal.compress.CompressExtension;

public class DeflateFrameExtension
extends CompressExtension {
    private static final Logger LOG = Log.getLogger(DeflateFrameExtension.class);

    @Override
    public String getName() {
        return "deflate-frame";
    }

    @Override
    int getRsvUseMode() {
        return 0;
    }

    @Override
    int getTailDropMode() {
        return 1;
    }

    @Override
    public void onFrame(Frame frame, Callback callback) {
        if (OpCode.isControlFrame(frame.getOpCode()) || !frame.isRsv1() || !frame.hasPayload()) {
            this.nextIncomingFrame(frame, callback);
            return;
        }
        try {
            if (this.getWebSocketCoreSession().getMaxFrameSize() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("maxFrameSize too large for ByteAccumulator");
            }
            ByteAccumulator accumulator = new ByteAccumulator((int)this.getWebSocketCoreSession().getMaxFrameSize());
            this.decompress(accumulator, frame.getPayload());
            this.decompress(accumulator, TAIL_BYTES_BUF.slice());
            this.forwardIncoming(frame, callback, accumulator);
        }
        catch (DataFormatException e) {
            throw new BadPayloadException(e);
        }
    }

    @Override
    public void setWebSocketCoreSession(WebSocketCoreSession coreSession) {
        coreSession.setAutoFragment(false);
        super.setWebSocketCoreSession(coreSession);
    }
}

