/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal.compress;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.AbstractExtension;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.internal.FrameEntry;
import org.eclipse.jetty.websocket.core.internal.compress.ByteAccumulator;

public abstract class CompressExtension
extends AbstractExtension {
    protected static final byte[] TAIL_BYTES = new byte[]{0, 0, -1, -1};
    protected static final ByteBuffer TAIL_BYTES_BUF = ByteBuffer.wrap(TAIL_BYTES);
    private static final Logger LOG = Log.getLogger(CompressExtension.class);
    protected static final int TAIL_DROP_NEVER = 0;
    protected static final int TAIL_DROP_ALWAYS = 1;
    protected static final int TAIL_DROP_FIN_ONLY = 2;
    protected static final int RSV_USE_ALWAYS = 0;
    protected static final int RSV_USE_ONLY_FIRST = 1;
    protected static final int INFLATE_BUFFER_SIZE = 8192;
    protected static final int INPUT_MAX_BUFFER_SIZE = 8192;
    private static final int DECOMPRESS_BUF_SIZE = 8192;
    private final Queue<FrameEntry> entries = new ArrayDeque<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private Deflater deflaterImpl;
    private Inflater inflaterImpl;
    protected AtomicInteger decompressCount = new AtomicInteger(0);
    private int tailDrop = this.getTailDropMode();
    private int rsvUse = this.getRsvUseMode();

    protected CompressExtension() {
    }

    public Deflater getDeflater() {
        if (this.deflaterImpl == null) {
            this.deflaterImpl = (Deflater)this.getDeflaterPool().acquire();
        }
        return this.deflaterImpl;
    }

    public Inflater getInflater() {
        if (this.inflaterImpl == null) {
            this.inflaterImpl = (Inflater)this.getInflaterPool().acquire();
        }
        return this.inflaterImpl;
    }

    public void releaseInflater() {
        this.getInflaterPool().release(this.inflaterImpl);
        this.inflaterImpl = null;
    }

    public void releaseDeflater() {
        this.getInflaterPool().release(this.inflaterImpl);
        this.inflaterImpl = null;
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    abstract int getTailDropMode();

    abstract int getRsvUseMode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardIncoming(Frame frame, Callback callback, ByteAccumulator accumulator) {
        Frame newFrame = Frame.copyWithoutPayload(frame);
        newFrame.setRsv1(false);
        ByteBuffer buffer = this.getBufferPool().acquire(accumulator.getLength(), false);
        try {
            int position = BufferUtil.flipToFill(buffer);
            try {
                accumulator.transferTo(buffer);
            }
            finally {
                BufferUtil.flipToFlush(buffer, position);
            }
            newFrame.setPayload(buffer);
            this.nextIncomingFrame(newFrame, callback);
        }
        finally {
            this.getBufferPool().release(buffer);
        }
    }

    protected void decompress(ByteAccumulator accumulator, ByteBuffer buf) throws DataFormatException {
        if (buf == null || !buf.hasRemaining()) {
            return;
        }
        byte[] output = new byte[8192];
        Inflater inflater = this.getInflater();
        block0: while (buf.hasRemaining() && inflater.needsInput()) {
            int read;
            if (!CompressExtension.supplyInput(inflater, buf)) {
                LOG.debug("Needed input, but no buffer could supply input", new Object[0]);
                return;
            }
            while ((read = inflater.inflate(output)) >= 0) {
                if (read == 0) {
                    LOG.debug("Decompress: read 0 {}", CompressExtension.toDetail(inflater));
                    continue block0;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Decompressed {} bytes: {}", read, CompressExtension.toDetail(inflater));
                }
                accumulator.copyChunk(output, 0, read);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decompress: exiting {}", CompressExtension.toDetail(inflater));
        }
    }

    @Override
    public void sendFrame(Frame frame, Callback callback, boolean batch) {
        if (this.flusher.isFailed()) {
            this.notifyCallbackFailure(callback, new ZipException());
            return;
        }
        FrameEntry entry = new FrameEntry(frame, callback, batch);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", entry);
        }
        this.offerEntry(entry);
        this.flusher.iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEntry(FrameEntry entry) {
        CompressExtension compressExtension = this;
        synchronized (compressExtension) {
            this.entries.offer(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameEntry pollEntry() {
        CompressExtension compressExtension = this;
        synchronized (compressExtension) {
            return this.entries.poll();
        }
    }

    protected void notifyCallbackSuccess(Callback callback) {
        block3: {
            try {
                if (callback != null) {
                    callback.succeeded();
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + callback, x);
            }
        }
    }

    protected void notifyCallbackFailure(Callback callback, Throwable failure) {
        block3: {
            try {
                if (callback != null) {
                    callback.failed(failure);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + callback, x);
            }
        }
    }

    private static boolean supplyInput(Inflater inflater, ByteBuffer buf) {
        int inputOffset;
        byte[] input;
        int len;
        if (buf.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Inflater", new Object[0]);
            }
            return false;
        }
        if (buf.hasArray()) {
            len = buf.remaining();
            input = buf.array();
            inputOffset = buf.position() + buf.arrayOffset();
            buf.position(buf.position() + len);
        } else {
            len = Math.min(8192, buf.remaining());
            input = new byte[len];
            inputOffset = 0;
            buf.get(input, 0, len);
        }
        inflater.setInput(input, inputOffset, len);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", input.length, CompressExtension.toDetail(inflater));
        }
        return true;
    }

    private static boolean supplyInput(Deflater deflater, ByteBuffer buf) {
        int inputOffset;
        byte[] input;
        int len;
        if (buf.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Deflater", new Object[0]);
            }
            return false;
        }
        if (buf.hasArray()) {
            len = buf.remaining();
            input = buf.array();
            inputOffset = buf.position() + buf.arrayOffset();
            buf.position(buf.position() + len);
        } else {
            len = Math.min(8192, buf.remaining());
            input = new byte[len];
            inputOffset = 0;
            buf.get(input, 0, len);
        }
        deflater.setInput(input, inputOffset, len);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", input.length, CompressExtension.toDetail(deflater));
        }
        return true;
    }

    private static String toDetail(Inflater inflater) {
        return String.format("Inflater[finished=%b,read=%d,written=%d,remaining=%d,in=%d,out=%d]", inflater.finished(), inflater.getBytesRead(), inflater.getBytesWritten(), inflater.getRemaining(), inflater.getTotalIn(), inflater.getTotalOut());
    }

    private static String toDetail(Deflater deflater) {
        return String.format("Deflater[finished=%b,read=%d,written=%d,in=%d,out=%d]", deflater.finished(), deflater.getBytesRead(), deflater.getBytesWritten(), deflater.getTotalIn(), deflater.getTotalOut());
    }

    public static boolean endsWithTail(ByteBuffer buf) {
        if (buf == null || buf.remaining() < TAIL_BYTES.length) {
            return false;
        }
        int limit = buf.limit();
        for (int i2 = TAIL_BYTES.length; i2 > 0; --i2) {
            if (buf.get(limit - i2) == TAIL_BYTES[TAIL_BYTES.length - i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class Flusher
    extends IteratingCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        @Override
        public void succeeded() {
            if (this.finished) {
                CompressExtension.this.notifyCallbackSuccess(this.current.callback);
            }
            super.succeeded();
        }

        @Override
        public void failed(Throwable cause) {
            CompressExtension.this.releaseInflater();
            CompressExtension.this.releaseDeflater();
            CompressExtension.this.notifyCallbackFailure(this.current.callback, cause);
            LOG.warn(cause);
            super.failed(cause);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this.finished) {
                this.current = CompressExtension.this.pollEntry();
                LOG.debug("Processing {}", this.current);
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.deflate(this.current);
            } else {
                this.compress(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void deflate(FrameEntry entry) {
            Frame frame = entry.frame;
            boolean batch = entry.batch;
            if (OpCode.isControlFrame(frame.getOpCode())) {
                CompressExtension.this.nextOutgoingFrame(frame, this, batch);
                return;
            }
            this.compress(entry, true);
        }

        private void compress(FrameEntry entry, boolean first) {
            Frame frame = entry.frame;
            ByteBuffer data = frame.getPayload();
            int remaining = data.remaining();
            int outputLength = Math.max(256, data.remaining());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressing {}: {} bytes in {} bytes chunk", entry, remaining, outputLength);
            }
            boolean needsCompress = true;
            Deflater deflater = CompressExtension.this.getDeflater();
            if (deflater.needsInput() && !CompressExtension.supplyInput(deflater, data)) {
                needsCompress = false;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] output = new byte[outputLength];
            boolean fin = frame.isFin();
            while (needsCompress) {
                int compressed = deflater.deflate(output, 0, outputLength, 2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Wrote {} bytes to output buffer", compressed);
                }
                out.write(output, 0, compressed);
                if (compressed >= outputLength) continue;
                needsCompress = false;
            }
            ByteBuffer payload = ByteBuffer.wrap(out.toByteArray());
            if (payload.remaining() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("compressed[] bytes = {}", BufferUtil.toDetailString(payload));
                }
                if (CompressExtension.this.tailDrop == 1) {
                    if (CompressExtension.endsWithTail(payload)) {
                        payload.limit(payload.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_ALWAYS) = {}", BufferUtil.toDetailString(payload));
                    }
                } else if (CompressExtension.this.tailDrop == 2) {
                    if (frame.isFin() && CompressExtension.endsWithTail(payload)) {
                        payload.limit(payload.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_FIN_ONLY) = {}", BufferUtil.toDetailString(payload));
                    }
                }
            } else if (fin) {
                payload = ByteBuffer.wrap(new byte[]{0});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressed {}: input:{} -> payload:{}", entry, outputLength, payload.remaining());
            }
            boolean continuation = frame.getOpCode() == 0 || !first;
            Frame chunk = new Frame(continuation ? (byte)0 : frame.getOpCode());
            if (CompressExtension.this.rsvUse == 1) {
                chunk.setRsv1(!continuation);
            } else {
                chunk.setRsv1(true);
            }
            chunk.setPayload(payload);
            chunk.setFin(fin);
            CompressExtension.this.nextOutgoingFrame(chunk, this, entry.batch);
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable x) {
            FrameEntry entry;
            while ((entry = CompressExtension.this.pollEntry()) != null) {
                CompressExtension.this.notifyCallbackFailure(entry.callback, x);
            }
        }
    }
}

