/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.AbstractExtension;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.internal.FrameEntry;

public class FragmentExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(FragmentExtension.class);
    private final Queue<FrameEntry> entries = new ArrayDeque<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private int maxLength;

    @Override
    public String getName() {
        return "fragment";
    }

    @Override
    public void onFrame(Frame frame, Callback callback) {
        this.nextIncomingFrame(frame, callback);
    }

    @Override
    public void sendFrame(Frame frame, Callback callback, boolean batch) {
        int length;
        ByteBuffer payload = frame.getPayload();
        int n = length = payload != null ? payload.remaining() : 0;
        if (OpCode.isControlFrame(frame.getOpCode()) || this.maxLength <= 0 || length <= this.maxLength) {
            this.nextOutgoingFrame(frame, callback, batch);
            return;
        }
        FrameEntry entry = new FrameEntry(frame, callback, batch);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", entry);
        }
        this.offerEntry(entry);
        this.flusher.iterate();
    }

    @Override
    public void init(ExtensionConfig config, WebSocketComponents components) {
        super.init(config, components);
        this.maxLength = config.getParameter("maxLength", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEntry(FrameEntry entry) {
        FragmentExtension fragmentExtension = this;
        synchronized (fragmentExtension) {
            this.entries.offer(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameEntry pollEntry() {
        FragmentExtension fragmentExtension = this;
        synchronized (fragmentExtension) {
            return this.entries.poll();
        }
    }

    private class Flusher
    extends IteratingCallback
    implements Callback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this.finished) {
                this.current = FragmentExtension.this.pollEntry();
                LOG.debug("Processing {}", this.current);
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.fragment(this.current, true);
            } else {
                this.fragment(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void fragment(FrameEntry entry, boolean first) {
            Frame frame = entry.frame;
            ByteBuffer payload = frame.getPayload();
            int remaining = payload.remaining();
            int length = Math.min(remaining, FragmentExtension.this.maxLength);
            this.finished = length == remaining;
            boolean continuation = frame.getOpCode() == 0 || !first;
            Frame fragment = new Frame(continuation ? (byte)0 : frame.getOpCode());
            boolean fin = frame.isFin() && this.finished;
            fragment.setFin(fin);
            int limit = payload.limit();
            int newLimit = payload.position() + length;
            payload.limit(newLimit);
            ByteBuffer payloadFragment = payload.slice();
            payload.limit(limit);
            fragment.setPayload(payloadFragment);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fragmented {}->{}", frame, fragment);
            }
            payload.position(newLimit);
            FragmentExtension.this.nextOutgoingFrame(fragment, this, entry.batch);
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable x) {
        }

        @Override
        public void succeeded() {
            this.notifyCallbackSuccess(this.current.callback);
            super.succeeded();
        }

        @Override
        public void failed(Throwable cause) {
            this.notifyCallbackFailure(this.current.callback, cause);
            this.succeeded();
        }

        private void notifyCallbackSuccess(Callback callback) {
            block3: {
                try {
                    if (callback != null) {
                        callback.succeeded();
                    }
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying success of callback " + callback, x);
                }
            }
        }

        private void notifyCallbackFailure(Callback callback, Throwable failure) {
            block3: {
                try {
                    if (callback != null) {
                        callback.failed(failure);
                    }
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying failure of callback " + callback, x);
                }
            }
        }
    }
}

