/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.common.JettyWebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.core.FrameHandler;

public class WebSocketSession
extends AbstractLifeCycle
implements Session,
SuspendToken,
Dumpable {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final FrameHandler.CoreSession coreSession;
    private final JettyWebSocketFrameHandler frameHandler;
    private final JettyWebSocketRemoteEndpoint remoteEndpoint;
    private final UpgradeRequest upgradeRequest;
    private final UpgradeResponse upgradeResponse;

    public WebSocketSession(FrameHandler.CoreSession coreSession, JettyWebSocketFrameHandler frameHandler) {
        this.frameHandler = Objects.requireNonNull(frameHandler);
        this.coreSession = Objects.requireNonNull(coreSession);
        this.upgradeRequest = frameHandler.getUpgradeRequest();
        this.upgradeResponse = frameHandler.getUpgradeResponse();
        this.remoteEndpoint = new JettyWebSocketRemoteEndpoint(coreSession, frameHandler.getBatchMode());
    }

    @Override
    public void close() {
        this.remoteEndpoint.close();
    }

    @Override
    public void close(CloseStatus closeStatus) {
        this.remoteEndpoint.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    @Override
    public void close(int statusCode, String reason) {
        this.remoteEndpoint.close(statusCode, reason);
    }

    @Override
    public WebSocketBehavior getBehavior() {
        switch (this.coreSession.getBehavior()) {
            case CLIENT: {
                return WebSocketBehavior.CLIENT;
            }
            case SERVER: {
                return WebSocketBehavior.SERVER;
            }
        }
        return null;
    }

    @Override
    public Duration getIdleTimeout() {
        return this.coreSession.getIdleTimeout();
    }

    @Override
    public int getInputBufferSize() {
        return this.coreSession.getInputBufferSize();
    }

    @Override
    public int getOutputBufferSize() {
        return this.coreSession.getOutputBufferSize();
    }

    @Override
    public long getMaxBinaryMessageSize() {
        return this.coreSession.getMaxBinaryMessageSize();
    }

    @Override
    public long getMaxTextMessageSize() {
        return this.coreSession.getMaxTextMessageSize();
    }

    @Override
    public void setIdleTimeout(Duration duration) {
        this.coreSession.setIdleTimeout(duration);
    }

    @Override
    public void setInputBufferSize(int size) {
        this.coreSession.setInputBufferSize(size);
    }

    @Override
    public void setOutputBufferSize(int size) {
        this.coreSession.setOutputBufferSize(size);
    }

    @Override
    public void setMaxBinaryMessageSize(long size) {
        this.coreSession.setMaxBinaryMessageSize(size);
    }

    @Override
    public void setMaxTextMessageSize(long size) {
        this.coreSession.setMaxTextMessageSize(size);
    }

    @Override
    public String getProtocolVersion() {
        return this.upgradeRequest.getProtocolVersion();
    }

    @Override
    public JettyWebSocketRemoteEndpoint getRemote() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean isOpen() {
        return this.remoteEndpoint.getCoreSession().isOutputOpen();
    }

    @Override
    public boolean isSecure() {
        return this.upgradeRequest.isSecure();
    }

    @Override
    public void disconnect() {
        this.coreSession.abort();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.coreSession.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.coreSession.getRemoteAddress();
    }

    @Override
    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    @Override
    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    @Override
    public SuspendToken suspend() {
        this.frameHandler.suspend();
        return this;
    }

    @Override
    public void resume() {
        this.frameHandler.resume();
    }

    public FrameHandler.CoreSession getCoreSession() {
        return this.coreSession;
    }

    @Override
    protected void doStop() throws Exception {
        this.coreSession.close(1001, "Container being shut down", new Callback(){

            @Override
            public void succeeded() {
                WebSocketSession.this.coreSession.abort();
            }

            @Override
            public void failed(Throwable x) {
                WebSocketSession.this.coreSession.abort();
            }
        });
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.upgradeRequest, this.coreSession, this.remoteEndpoint, this.frameHandler);
    }

    @Override
    public String dumpSelf() {
        return String.format("%s@%x[behavior=%s,idleTimeout=%dms]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getPolicy().getBehavior(), this.getIdleTimeout().toMillis()});
    }

    @Override
    public String toString() {
        return String.format("WebSocketSession[%s,to=%s,%s,%s]", new Object[]{this.getBehavior(), this.getIdleTimeout(), this.coreSession, this.frameHandler});
    }
}

