/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class CookieCutter {
    protected static final Logger LOG = Log.getLogger(CookieCutter.class);
    protected final CookieCompliance _complianceMode;
    private final ComplianceViolation.Listener _complianceListener;

    protected CookieCutter(CookieCompliance compliance, ComplianceViolation.Listener complianceListener) {
        this._complianceMode = compliance;
        this._complianceListener = complianceListener;
    }

    protected void parseFields(List<String> rawFields) {
        StringBuilder unquoted = null;
        for (String hdr : rawFields) {
            String name = null;
            String cookieName = null;
            String cookieValue = null;
            String cookiePath = null;
            String cookieDomain = null;
            String cookieComment = null;
            int cookieVersion = 0;
            boolean invalue = false;
            boolean inQuoted = false;
            boolean quoted = false;
            boolean escaped = false;
            int tokenstart = -1;
            int tokenend = -1;
            int length = hdr.length();
            block30: for (int i2 = 0; i2 <= length; ++i2) {
                char c;
                char c2 = c = i2 == length ? (char)'\u0000' : hdr.charAt(i2);
                if (inQuoted) {
                    if (escaped) {
                        escaped = false;
                        if (c > '\u0000') {
                            unquoted.append(c);
                            continue;
                        }
                        unquoted.setLength(0);
                        inQuoted = false;
                        --i2;
                        continue;
                    }
                    switch (c) {
                        case '\"': {
                            inQuoted = false;
                            quoted = true;
                            tokenstart = i2;
                            tokenend = -1;
                            break;
                        }
                        case '\\': {
                            escaped = true;
                            break;
                        }
                        case '\u0000': {
                            unquoted.setLength(0);
                            inQuoted = false;
                            --i2;
                            break;
                        }
                        default: {
                            unquoted.append(c);
                            break;
                        }
                    }
                    continue;
                }
                if (invalue) {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case ',': {
                            if (CookieCompliance.Violation.COMMA_NOT_VALID_OCTET.isAllowedBy(this._complianceMode)) {
                                this.reportComplianceViolation(CookieCompliance.Violation.COMMA_NOT_VALID_OCTET, "Cookie " + cookieName);
                            } else {
                                if (quoted) {
                                    unquoted.append(hdr, tokenstart, i2--);
                                    inQuoted = true;
                                    quoted = false;
                                    break;
                                }
                                if (tokenstart < 0) {
                                    tokenstart = i2;
                                }
                                tokenend = i2;
                                break;
                            }
                        }
                        case '\u0000': 
                        case ';': {
                            String value;
                            if (quoted) {
                                value = unquoted.toString();
                                unquoted.setLength(0);
                                quoted = false;
                            } else {
                                value = tokenstart >= 0 ? (tokenend >= tokenstart ? hdr.substring(tokenstart, tokenend + 1) : hdr.substring(tokenstart)) : "";
                            }
                            try {
                                if (name.startsWith("$")) {
                                    if (CookieCompliance.Violation.RESERVED_NAMES_NOT_DOLLAR_PREFIXED.isAllowedBy(this._complianceMode)) {
                                        String lowercaseName;
                                        this.reportComplianceViolation(CookieCompliance.Violation.RESERVED_NAMES_NOT_DOLLAR_PREFIXED, "Cookie " + cookieName + " field " + name);
                                        switch (lowercaseName = name.toLowerCase(Locale.ENGLISH)) {
                                            case "$path": {
                                                cookiePath = value;
                                                break;
                                            }
                                            case "$domain": {
                                                cookieDomain = value;
                                                break;
                                            }
                                            case "$port": {
                                                cookieComment = "$port=" + value;
                                                break;
                                            }
                                            case "$version": {
                                                cookieVersion = Integer.parseInt(value);
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    if (cookieName != null) {
                                        this.addCookie(cookieName, cookieValue, cookieDomain, cookiePath, cookieVersion, cookieComment);
                                        cookieDomain = null;
                                        cookiePath = null;
                                        cookieComment = null;
                                    }
                                    cookieName = name;
                                    cookieValue = value;
                                }
                            }
                            catch (Exception e) {
                                LOG.debug(e);
                            }
                            name = null;
                            tokenstart = -1;
                            invalue = false;
                            break;
                        }
                        case '\"': {
                            if (tokenstart < 0) {
                                tokenstart = i2;
                                inQuoted = true;
                                if (unquoted != null) continue block30;
                                unquoted = new StringBuilder();
                                break;
                            }
                        }
                        default: {
                            if (quoted) {
                                unquoted.append(hdr, tokenstart, i2--);
                                inQuoted = true;
                                quoted = false;
                                break;
                            }
                            if (tokenstart < 0) {
                                tokenstart = i2;
                            }
                            tokenend = i2;
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '\t': 
                    case ' ': {
                        continue block30;
                    }
                    case '=': {
                        if (quoted) {
                            name = unquoted.toString();
                            unquoted.setLength(0);
                            quoted = false;
                        } else if (tokenstart >= 0) {
                            name = tokenend >= tokenstart ? hdr.substring(tokenstart, tokenend + 1) : hdr.substring(tokenstart);
                        }
                        tokenstart = -1;
                        invalue = true;
                        continue block30;
                    }
                    default: {
                        if (quoted) {
                            unquoted.append(hdr, tokenstart, i2--);
                            inQuoted = true;
                            quoted = false;
                            continue block30;
                        }
                        if (tokenstart < 0) {
                            tokenstart = i2;
                        }
                        tokenend = i2;
                        continue block30;
                    }
                }
            }
            if (cookieName == null) continue;
            this.addCookie(cookieName, cookieValue, cookieDomain, cookiePath, cookieVersion, cookieComment);
        }
    }

    protected void reportComplianceViolation(CookieCompliance.Violation violation, String reason) {
        if (this._complianceListener != null) {
            this._complianceListener.onComplianceViolation(this._complianceMode, violation, reason);
        }
    }

    protected abstract void addCookie(String var1, String var2, String var3, String var4, int var5, String var6);
}

