/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.AsyncContent;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherRequestContent
implements Request.Content,
Subscriber<Content.Chunk> {
    private final AsyncContent asyncContent = new AsyncContent();
    private final ReactiveRequest.Content reactiveContent;
    private Subscription subscription;

    public PublisherRequestContent(ReactiveRequest.Content content) {
        this.reactiveContent = content;
        content.subscribe(this);
    }

    public long getLength() {
        return this.reactiveContent.getLength();
    }

    public Content.Chunk read() {
        return this.asyncContent.read();
    }

    public void demand(Runnable runnable) {
        this.asyncContent.demand(runnable);
    }

    public void fail(Throwable failure) {
        this.onError(failure);
    }

    public String getContentType() {
        return this.reactiveContent.getContentType();
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(Content.Chunk chunk) {
        this.asyncContent.write(chunk.isLast(), chunk.getByteBuffer(), Callback.from(() -> ((Content.Chunk)chunk).release(), (Callback)Callback.from(() -> this.subscription.request(1L), x -> this.subscription.cancel())));
    }

    public void onError(Throwable failure) {
        this.asyncContent.fail(failure);
    }

    public void onComplete() {
        this.asyncContent.close();
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

