/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSinglePublisher<T>
implements Publisher<T>,
Subscription {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Subscriber<? super T> subscriber;
    private boolean cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super T> subscriber) {
        IllegalStateException failure = null;
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            if (this.subscriber != null) {
                failure = new IllegalStateException("multiple subscribers not supported");
            } else {
                this.subscriber = subscriber;
            }
        }
        if (failure != null) {
            this.onFailure(failure);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} subscription from {}", (Object)this, subscriber);
            }
            subscriber.onSubscribe((Subscription)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscriber<? super T> subscriber() {
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            return this.subscriber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        IllegalArgumentException failure = null;
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            if (this.isCancelled()) {
                return;
            }
            if (n <= 0L) {
                failure = new IllegalArgumentException("reactive stream violation rule 3.9");
            }
        }
        if (failure != null) {
            this.onFailure(failure);
        } else {
            this.onRequest(n);
        }
    }

    protected abstract void onRequest(long var1);

    protected void onFailure(Throwable failure) {
        this.subscriber().onError(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            this.cancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCancelled() {
        AbstractSinglePublisher abstractSinglePublisher = this;
        synchronized (abstractSinglePublisher) {
            return this.cancelled;
        }
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

