/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Subscriber;

public class TextContent
extends AbstractSinglePublisher<ContentChunk>
implements ReactiveRequest.Content {
    private final String mediaType;
    private final Charset encoding;
    private final byte[] bytes;
    private boolean complete;

    public TextContent(String text, String mediaType, Charset encoding) {
        this.mediaType = Objects.requireNonNull(mediaType);
        this.encoding = Objects.requireNonNull(encoding);
        this.bytes = text.getBytes(encoding);
    }

    @Override
    public long getLength() {
        return this.bytes.length;
    }

    @Override
    public String getContentType() {
        return this.mediaType + ";charset=" + this.encoding.name();
    }

    @Override
    protected void onRequest(long n) {
        if (!this.complete) {
            this.complete = true;
            Subscriber subscriber = this.subscriber();
            subscriber.onNext((Object)new ContentChunk(ByteBuffer.wrap(this.bytes), Callback.NOOP));
            subscriber.onComplete();
        }
    }
}

