/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy.entry;

import java.net.URL;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.PolicyException;
import org.eclipse.jetty.policy.entry.AbstractEntry;
import org.eclipse.jetty.policy.entry.PermissionEntry;
import org.eclipse.jetty.policy.entry.PrincipalEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrantEntry
extends AbstractEntry {
    private String signers;
    private String codebase;
    private Collection<PrincipalEntry> principalNodes;
    private Collection<PermissionEntry> permissionNodes;
    private PermissionCollection permissions;
    private Certificate[] signerArray;
    private CodeSource codesource;
    private Principal[] principals;

    public void addPrincipal(PrincipalEntry pe) {
        if (this.principalNodes == null) {
            this.principalNodes = new HashSet<PrincipalEntry>();
        }
        this.principalNodes.add(pe);
    }

    @Override
    public void expand(PolicyContext context) throws PolicyException {
        if (this.signers != null) {
            this.signerArray = this.resolveToCertificates(context.getKeystore(), this.signers);
        }
        this.codebase = context.evaluate(this.codebase);
        if (this.principalNodes != null) {
            HashSet<Principal> principalSet = new HashSet<Principal>();
            for (PrincipalEntry node : this.principalNodes) {
                node.expand(context);
                principalSet.add(node.toPrincipal(context));
            }
            this.principals = principalSet.toArray(new Principal[principalSet.size()]);
        }
        context.setPrincipals(this.principals);
        this.permissions = new Permissions();
        for (PermissionEntry node : this.permissionNodes) {
            node.expand(context);
            this.permissions.add(node.toPermission());
        }
        context.setPrincipals(null);
        this.setExpanded(true);
    }

    public PermissionCollection getPermissions() throws PolicyException {
        return this.permissions;
    }

    public Principal[] getPrincipals() throws PolicyException {
        return this.principals;
    }

    public CodeSource getCodeSource() throws PolicyException {
        if (!this.isExpanded()) {
            throw new PolicyException("GrantNode needs to be expanded.");
        }
        try {
            if (this.codesource == null && this.codebase != null) {
                URL url = new URL(this.codebase);
                this.codesource = new CodeSource(url, this.signerArray);
            }
            return this.codesource;
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    private Certificate[] resolveToCertificates(KeyStore keyStore, String signers) throws PolicyException {
        if (keyStore == null) {
            Certificate[] certs = null;
            return certs;
        }
        HashSet<Certificate> certificateSet = new HashSet<Certificate>();
        StringTokenizer strTok = new StringTokenizer(signers, ",");
        int i = 0;
        while (strTok.hasMoreTokens()) {
            try {
                Certificate certificate = keyStore.getCertificate(strTok.nextToken().trim());
                if (certificate != null) {
                    certificateSet.add(certificate);
                }
            }
            catch (KeyStoreException kse) {
                throw new PolicyException(kse);
            }
            ++i;
        }
        return certificateSet.toArray(new Certificate[certificateSet.size()]);
    }

    public void setSigners(String signers) {
        this.signers = signers;
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public void setPrincipals(Collection<PrincipalEntry> principals) {
        this.principalNodes = principals;
    }

    public void setPermissions(Collection<PermissionEntry> permissions) {
        this.permissionNodes = permissions;
    }
}

