/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.policy.PolicyBlock;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.loader.DefaultPolicyLoader;
import org.eclipse.jetty.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyPolicy
extends Policy {
    private static boolean __DEBUG = false;
    private final Set<String> _policies;
    private final Set<PolicyBlock> _grants = new HashSet<PolicyBlock>();
    private final Map<Object, PermissionCollection> _cache = new HashMap<Object, PermissionCollection>();
    private final PolicyContext _context = new PolicyContext();
    private final Scanner scanner = new Scanner();
    private boolean initialized = false;

    public JettyPolicy(Set<String> policies, Map<String, String> properties) {
        try {
            __DEBUG = Boolean.getBoolean("org.eclipse.jetty.policy.DEBUG");
        }
        catch (AccessControlException ace) {
            __DEBUG = false;
        }
        this._policies = policies;
        this._context.setProperties(properties);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (!this.initialized) {
            this.refresh();
        }
        if (this._cache.containsKey(domain)) {
            return this._cache.get(domain);
        }
        Map<Object, PermissionCollection> map = this._cache;
        synchronized (map) {
            if (this._cache.containsKey(domain)) {
                return this._cache.get(domain);
            }
            Permissions perms = new Permissions();
            for (PolicyBlock policyBlock : this._grants) {
                ProtectionDomain grantPD = policyBlock.toProtectionDomain();
                if (__DEBUG) {
                    System.out.println("----START----");
                    System.out.println("PDCS: " + policyBlock.getCodeSource());
                    System.out.println("CS: " + domain.getCodeSource());
                }
                if (grantPD.getCodeSource() == null || grantPD.getCodeSource().implies(domain.getCodeSource()) && grantPD.getPrincipals() == null || grantPD.getCodeSource().implies(domain.getCodeSource()) && JettyPolicy.validate(grantPD.getPrincipals(), domain.getPrincipals())) {
                    Enumeration<Permission> e = policyBlock.getPermissions().elements();
                    while (e.hasMoreElements()) {
                        Permission perm = e.nextElement();
                        if (__DEBUG) {
                            System.out.println("D: " + perm);
                        }
                        ((PermissionCollection)perms).add(perm);
                    }
                }
                if (!__DEBUG) continue;
                System.out.println("----STOP----");
            }
            this._cache.put(domain, perms);
            return perms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        Object object;
        if (!this.initialized) {
            object = this;
            synchronized (object) {
                this.refresh();
            }
        }
        if (this._cache.containsKey(codesource)) {
            return this._cache.get(codesource);
        }
        object = this._cache;
        synchronized (object) {
            if (this._cache.containsKey(codesource)) {
                return this._cache.get(codesource);
            }
            Permissions perms = new Permissions();
            for (PolicyBlock policyBlock : this._grants) {
                ProtectionDomain grantPD = policyBlock.toProtectionDomain();
                if (grantPD.getCodeSource() != null && !grantPD.getCodeSource().implies(codesource)) continue;
                if (__DEBUG) {
                    System.out.println("----START----");
                    System.out.println("PDCS: " + grantPD.getCodeSource());
                    System.out.println("CS: " + codesource);
                }
                Enumeration<Permission> e = policyBlock.getPermissions().elements();
                while (e.hasMoreElements()) {
                    Permission perm = e.nextElement();
                    if (__DEBUG) {
                        System.out.println("D: " + perm);
                    }
                    ((PermissionCollection)perms).add(perm);
                }
                if (!__DEBUG) continue;
                System.out.println("----STOP----");
            }
            this._cache.put(codesource, perms);
            return perms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection pc;
        Map<Object, PermissionCollection> map;
        if (this._cache == null) {
            map = this._cache;
            synchronized (map) {
                this.refresh();
            }
        }
        map = this._cache;
        synchronized (map) {
            pc = this._cache.get(domain);
        }
        if (pc != null) {
            return pc.implies(permission);
        }
        pc = this.getPermissions(domain);
        if (pc == null) {
            return false;
        }
        map = this._cache;
        synchronized (map) {
            this._cache.put(domain, pc);
        }
        return pc.implies(permission);
    }

    private static boolean validate(Principal[] permCerts, Principal[] classCerts) {
        if (classCerts == null) {
            return false;
        }
        for (int i = 0; i < permCerts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < classCerts.length; ++j) {
                if (!((Object)permCerts[i]).equals(classCerts[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refresh() {
        try {
            if (!this.initialized) {
                this.initialize();
            }
            Iterator<Object> i = this._cache.keySet().iterator();
            while (i.hasNext()) {
                System.out.println(i.next().toString());
            }
            if (__DEBUG) {
                System.out.println("refreshing policy files");
            }
            HashSet<PolicyBlock> clean = new HashSet<PolicyBlock>();
            Iterator<String> i2 = this._policies.iterator();
            while (i2.hasNext()) {
                File policyFile = new File(i2.next());
                clean.addAll(DefaultPolicyLoader.load(new FileInputStream(policyFile), this._context));
            }
            Map<Object, PermissionCollection> map = this._cache;
            synchronized (map) {
                this._grants.clear();
                this._grants.addAll(clean);
                this._cache.clear();
            }
            if (__DEBUG) {
                System.out.println("finished reloading policies");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        ArrayList<File> scanDirs = new ArrayList<File>();
        Iterator<String> i = this._policies.iterator();
        while (i.hasNext()) {
            File policyFile = new File(i.next());
            scanDirs.add(policyFile.getParentFile());
        }
        this.scanner.addListener((Scanner.Listener)new Scanner.DiscreteListener(){

            public void fileRemoved(String filename) throws Exception {
            }

            public void fileChanged(String filename) throws Exception {
                if (filename.endsWith("policy")) {
                    JettyPolicy.this.refresh();
                }
            }

            public void fileAdded(String filename) throws Exception {
            }
        });
        this.scanner.setScanDirs(scanDirs);
        this.scanner.start();
        this.scanner.setScanInterval(10);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintStream out) {
        PrintWriter write = new PrintWriter(out);
        write.println("dumping policy settings");
        Map<Object, PermissionCollection> map = this._cache;
        synchronized (map) {
            for (Object o : this._cache.keySet()) {
                write.println(o.toString());
            }
        }
        write.flush();
    }
}

