/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.policy.PolicyBlock;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.loader.DefaultPolicyLoader;
import org.eclipse.jetty.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyPolicy
extends Policy {
    private static boolean __DEBUG = false;
    private final Set<String> _policies;
    private final Map<ProtectionDomain, PolicyBlock> pdMapping = Collections.synchronizedMap(new HashMap());
    private final PolicyContext _context = new PolicyContext();
    private final Scanner scanner = new Scanner();
    private boolean initialized = false;

    public JettyPolicy(Set<String> policies, Map<String, String> properties) {
        try {
            __DEBUG = Boolean.getBoolean("org.eclipse.jetty.policy.DEBUG");
        }
        catch (AccessControlException ace) {
            __DEBUG = false;
        }
        this._policies = policies;
        this._context.setProperties(properties);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (!this.initialized) {
            JettyPolicy jettyPolicy = this;
            synchronized (jettyPolicy) {
                this.refresh();
            }
        }
        Permissions perms = new Permissions();
        Map<ProtectionDomain, PolicyBlock> map = this.pdMapping;
        synchronized (map) {
            for (ProtectionDomain pd : this.pdMapping.keySet()) {
                if (__DEBUG) {
                    System.out.println("----START----");
                    System.out.println("PDCS: " + pd.getCodeSource());
                    System.out.println("CS: " + domain.getCodeSource());
                }
                if ((pd.getCodeSource() == null || pd.getCodeSource().implies(domain.getCodeSource()) && pd.getPrincipals() == null || pd.getCodeSource().implies(domain.getCodeSource()) && JettyPolicy.validate(pd.getPrincipals(), domain.getPrincipals())) && this.pdMapping.get(pd) != null) {
                    Enumeration<Permission> e = this.pdMapping.get(pd).getPermissions().elements();
                    while (e.hasMoreElements()) {
                        Permission perm = e.nextElement();
                        if (__DEBUG) {
                            System.out.println("D: " + perm);
                        }
                        ((PermissionCollection)perms).add(perm);
                    }
                }
                if (!__DEBUG) continue;
                System.out.println("----STOP----");
            }
        }
        return perms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        if (!this.initialized) {
            JettyPolicy jettyPolicy = this;
            synchronized (jettyPolicy) {
                this.refresh();
            }
        }
        Permissions perms = new Permissions();
        Map<ProtectionDomain, PolicyBlock> map = this.pdMapping;
        synchronized (map) {
            for (ProtectionDomain pd : this.pdMapping.keySet()) {
                if (pd.getCodeSource() != null && !pd.getCodeSource().implies(codesource)) continue;
                if (__DEBUG) {
                    System.out.println("----START----");
                    System.out.println("PDCS: " + pd.getCodeSource());
                    System.out.println("CS: " + codesource);
                }
                if (this.pdMapping.get(pd) != null) {
                    Enumeration<Permission> e = this.pdMapping.get(pd).getPermissions().elements();
                    while (e.hasMoreElements()) {
                        Permission perm = e.nextElement();
                        if (__DEBUG) {
                            System.out.println("D: " + perm);
                        }
                        ((PermissionCollection)perms).add(perm);
                    }
                }
                if (!__DEBUG) continue;
                System.out.println("----STOP----");
            }
        }
        return perms;
    }

    private static boolean validate(Principal[] permCerts, Principal[] classCerts) {
        if (classCerts == null) {
            return false;
        }
        for (int i = 0; i < permCerts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < classCerts.length; ++j) {
                if (!((Object)permCerts[i]).equals(classCerts[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        try {
            if (!this.initialized) {
                this.initialize();
            }
            if (__DEBUG) {
                System.out.println("refreshing policy files");
            }
            Map<ProtectionDomain, PolicyBlock> map = this.pdMapping;
            synchronized (map) {
                this.pdMapping.clear();
                Iterator<String> i = this._policies.iterator();
                while (i.hasNext()) {
                    File policyFile = new File(i.next());
                    this.pdMapping.putAll(DefaultPolicyLoader.load(new FileInputStream(policyFile), this._context));
                }
                if (__DEBUG) {
                    System.out.println("resetting policies");
                    System.setSecurityManager(null);
                    Policy.setPolicy(null);
                    Policy.setPolicy(this);
                    System.setSecurityManager(new SecurityManager());
                    System.out.println("finished reloading policies");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() throws Exception {
        ArrayList<File> scanDirs = new ArrayList<File>();
        Iterator<String> i = this._policies.iterator();
        while (i.hasNext()) {
            File policyFile = new File(i.next());
            scanDirs.add(policyFile.getParentFile());
        }
        this.scanner.addListener((Scanner.Listener)new Scanner.DiscreteListener(){

            public void fileRemoved(String filename) throws Exception {
            }

            public void fileChanged(String filename) throws Exception {
                JettyPolicy.this.refresh();
            }

            public void fileAdded(String filename) throws Exception {
            }
        });
        this.scanner.setScanDirs(scanDirs);
        this.scanner.start();
        this.scanner.setScanInterval(10);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintStream out) {
        PrintWriter write = new PrintWriter(out);
        write.println("dumping policy settings");
        Map<ProtectionDomain, PolicyBlock> map = this.pdMapping;
        synchronized (map) {
            for (ProtectionDomain domain : this.pdMapping.keySet()) {
                PolicyBlock block = this.pdMapping.get(domain);
                write.println(domain.toString());
            }
        }
        write.flush();
    }
}

