/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy;

import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.eclipse.jetty.policy.PolicyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyContext {
    private Map<String, String> properties = new HashMap<String, String>();
    private Principal[] principals;
    private KeyStore keystore;

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeyStore keystore) {
        this.keystore = keystore;
    }

    public Principal[] getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Principal[] principals) {
        this.principals = principals;
    }

    public String evaluate(String s) throws PolicyException {
        s = this.processProtocols(s);
        int i1 = 0;
        int i2 = 0;
        while (s != null && (i1 = s.indexOf("${", i2)) >= 0 && (i2 = s.indexOf("}", i1 + 2)) >= 0) {
            String property = this.getProperty(s.substring(i1 + 2, i2));
            s = s.substring(0, i1) + property + s.substring(i2 + 1);
        }
        return s;
    }

    private String processProtocols(String s) throws PolicyException {
        int i1 = 0;
        int i2 = 0;
        while (s != null && (i1 = s.indexOf("${{", i2)) >= 0 && (i2 = s.indexOf("}}", i1 + 2)) >= 0) {
            String property;
            String target = s.substring(i1 + 3, i2);
            if (target.indexOf(":") >= 0) {
                String[] resolve = target.split(":");
                property = this.resolve(resolve[0], resolve[1]);
            } else {
                property = this.resolve(target, null);
            }
            s = s.substring(0, i1) + property + s.substring(i2 + 2);
        }
        return s;
    }

    private String getProperty(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return System.getProperty(name);
    }

    private String resolve(String protocol, String data) throws PolicyException {
        if ("self".equals(protocol)) {
            if (this.principals != null && this.principals.length != 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.principals.length; ++i) {
                    sb.append(this.principals[i].getClass().getName());
                    sb.append(" \"");
                    sb.append(this.principals[i].getName());
                    sb.append("\" ");
                }
                return sb.toString();
            }
            throw new PolicyException("self can not be expanded, missing principals");
        }
        if ("alias".equals(protocol)) {
            try {
                Certificate cert = this.keystore.getCertificate(data);
                if (cert instanceof X509Certificate) {
                    X500Principal principal = ((X509Certificate)cert).getSubjectX500Principal();
                    StringBuilder sb = new StringBuilder();
                    sb.append(principal.getClass().getName());
                    sb.append(" \"");
                    sb.append(principal.getName());
                    sb.append("\" ");
                    return sb.toString();
                }
                throw new PolicyException("alias can not be expanded, bad cert");
            }
            catch (Exception e) {
                throw new PolicyException("alias can not be expanded: " + data);
            }
        }
        throw new PolicyException("unknown protocol: " + protocol);
    }
}

