/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.policy.PolicyException;
import org.eclipse.jetty.policy.PropertyEvaluator;
import org.eclipse.jetty.policy.loader.PolicyFileScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolicyLoader {
    public static Map<ProtectionDomain, PermissionCollection> load(InputStream policyStream, PropertyEvaluator evaluator) throws PolicyException {
        HashMap<ProtectionDomain, PermissionCollection> pdMappings = new HashMap<ProtectionDomain, PermissionCollection>();
        KeyStore keystore = null;
        try {
            PolicyFileScanner loader = new PolicyFileScanner();
            ArrayList<GrantEntry> grantEntries = new ArrayList<GrantEntry>();
            ArrayList<KeystoreEntry> keystoreEntries = new ArrayList<KeystoreEntry>();
            loader.scanStream(new InputStreamReader(policyStream), grantEntries, keystoreEntries);
            Iterator i = keystoreEntries.iterator();
            while (i.hasNext()) {
                keystore = DefaultPolicyLoader.resolveKeyStore((KeystoreEntry)i.next(), evaluator);
            }
            for (GrantEntry grant : grantEntries) {
                ProtectionDomain pd;
                Permissions permissions = DefaultPolicyLoader.processPermissions(grant.permissions, keystore, evaluator);
                if (grant.codebase == null) {
                    pd = new ProtectionDomain(null, permissions);
                } else {
                    CodeSource codeSource = DefaultPolicyLoader.resolveToCodeSource(grant.codebase, evaluator);
                    pd = new ProtectionDomain(codeSource, permissions);
                }
                pdMappings.put(pd, null);
            }
            return pdMappings;
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    private static Permissions processPermissions(Collection<PermissionEntry> collection, KeyStore keystore, PropertyEvaluator evaluator) throws PolicyException {
        Permissions permissions = new Permissions();
        for (PermissionEntry perm : collection) {
            try {
                Class<?> clazz = Class.forName(perm.klass);
                if (perm.signers != null) {
                    if (!DefaultPolicyLoader.validate(DefaultPolicyLoader.resolveToCertificates(keystore, perm.signers), (Certificate[])clazz.getSigners())) continue;
                    permissions.add(DefaultPolicyLoader.resolveToPermission(clazz, perm, evaluator));
                    continue;
                }
                permissions.add(DefaultPolicyLoader.resolveToPermission(clazz, perm, evaluator));
            }
            catch (Exception e) {
                throw new PolicyException(e);
            }
        }
        return permissions;
    }

    private static Permission resolveToPermission(Class clazz, PermissionEntry perm, PropertyEvaluator evaluator) throws PolicyException {
        try {
            Permission permission = null;
            if (perm.name == null && perm.actions == null) {
                permission = (Permission)clazz.newInstance();
            } else if (perm.name != null && perm.actions == null) {
                Constructor c = clazz.getConstructor(String.class);
                permission = (Permission)c.newInstance(evaluator.evaluate(perm.name));
            } else if (perm.name != null && perm.actions != null) {
                Constructor c = clazz.getConstructor(String.class, String.class);
                permission = (Permission)c.newInstance(evaluator.evaluate(perm.name), perm.actions);
            }
            return permission;
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    private static CodeSource resolveToCodeSource(String codeBase, PropertyEvaluator evaluator) throws PolicyException {
        try {
            URL url = new URL(evaluator.evaluate(codeBase));
            Certificate[] cert = null;
            return new CodeSource(url, cert);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    private static Certificate[] resolveToCertificates(KeyStore keyStore, String signers) throws PolicyException {
        StringTokenizer strTok = new StringTokenizer(signers, ",");
        Certificate[] certificates = new Certificate[strTok.countTokens()];
        int i = 0;
        while (strTok.hasMoreTokens()) {
            try {
                certificates[i] = keyStore.getCertificate(strTok.nextToken().trim());
            }
            catch (KeyStoreException kse) {
                throw new PolicyException(kse);
            }
            ++i;
        }
        return certificates;
    }

    private static KeyStore resolveKeyStore(KeystoreEntry entry, PropertyEvaluator evaluator) throws PolicyException {
        try {
            KeyStore keyStore = KeyStore.getInstance(entry.type);
            URL keyStoreLocation = new URL(entry.url);
            InputStream istream = keyStoreLocation.openStream();
            keyStore.load(istream, null);
            return keyStore;
        }
        catch (KeyStoreException kse) {
            throw new PolicyException(kse);
        }
        catch (MalformedURLException me) {
            throw new PolicyException(me);
        }
        catch (IOException ioe) {
            throw new PolicyException(ioe);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PolicyException(e);
        }
        catch (CertificateException ce) {
            throw new PolicyException(ce);
        }
    }

    private static boolean validate(Certificate[] permCerts, Certificate[] classCerts) {
        for (int i = 0; i < permCerts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < classCerts.length; ++j) {
                if (!permCerts[i].equals(classCerts[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static class PermissionEntry {
        public String klass;
        public String name;
        public String actions;
        public String signers;
    }

    public static class PrincipalEntry {
        public static final String WILDCARD = "*";
        public String klass;
        public String name;
    }

    public static class GrantEntry {
        public String signers;
        public String codebase;
        public Collection<PrincipalEntry> principals;
        public Collection<PermissionEntry> permissions;

        public void addPrincipal(PrincipalEntry pe) {
            if (this.principals == null) {
                this.principals = new HashSet<PrincipalEntry>();
            }
            this.principals.add(pe);
        }
    }

    public static class KeystoreEntry {
        public String url;
        public String type;
    }
}

