/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy;

import java.io.File;
import java.io.FileInputStream;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.policy.PropertyEvaluator;
import org.eclipse.jetty.policy.loader.DefaultPolicyLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyPolicy
extends Policy {
    private Set<String> _policies;
    private PropertyEvaluator _evaluator;
    private Map<ProtectionDomain, PermissionCollection> pdMapping = Collections.synchronizedMap(new HashMap());

    public JettyPolicy(Set<String> policies, Map<String, String> properties) {
        this._policies = policies;
        this._evaluator = new PropertyEvaluator(properties);
        this.refresh();
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions perms = new Permissions();
        for (ProtectionDomain pd : this.pdMapping.keySet()) {
            Enumeration<Permission> e;
            if (pd.getCodeSource() != null && !pd.getCodeSource().implies(domain.getCodeSource())) continue;
            if (this.pdMapping.get(pd) != null) {
                e = this.pdMapping.get(pd).elements();
                while (e.hasMoreElements()) {
                    ((PermissionCollection)perms).add(e.nextElement());
                }
            }
            if (pd.getPermissions() == null) continue;
            e = pd.getPermissions().elements();
            while (e.hasMoreElements()) {
                ((PermissionCollection)perms).add(e.nextElement());
            }
        }
        return perms;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        for (ProtectionDomain pd : this.pdMapping.keySet()) {
            Enumeration<Permission> e;
            if (pd.getCodeSource() != null && !pd.getCodeSource().implies(codesource)) continue;
            if (this.pdMapping.get(pd) != null) {
                e = this.pdMapping.get(pd).elements();
                while (e.hasMoreElements()) {
                    ((PermissionCollection)perms).add(e.nextElement());
                }
            }
            if (pd.getPermissions() == null) continue;
            e = pd.getPermissions().elements();
            while (e.hasMoreElements()) {
                ((PermissionCollection)perms).add(e.nextElement());
            }
        }
        return perms;
    }

    @Override
    public void refresh() {
        try {
            this.pdMapping.clear();
            Iterator<String> i = this._policies.iterator();
            while (i.hasNext()) {
                File policyFile = new File(i.next());
                this.pdMapping.putAll(DefaultPolicyLoader.load(new FileInputStream(policyFile), this._evaluator));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

