/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plugins.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MavenUtils {
    private static final String DEFAULT_REPOSITORY_LOCATION = System.getProperty("user.home") + "/.m2/repository/";

    static File findGlobalSettingsXml() {
        String m2Home = System.getenv("M2_HOME");
        return new File(m2Home + "/conf/settings.xml");
    }

    static File findUserSettingsXml() {
        String userHome = System.getProperty("user.home");
        return new File(userHome + "/.m2/settings.xml");
    }

    public static String getLocalRepositoryLocation() {
        String repositoryLocation = DEFAULT_REPOSITORY_LOCATION;
        try {
            String tempRepositoryLocation = MavenUtils.parseSettingsXml(MavenUtils.findGlobalSettingsXml());
            if (tempRepositoryLocation != null) {
                repositoryLocation = tempRepositoryLocation;
            }
            if ((tempRepositoryLocation = MavenUtils.parseSettingsXml(MavenUtils.findUserSettingsXml())) != null) {
                repositoryLocation = tempRepositoryLocation;
            }
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException(e);
        }
        return repositoryLocation;
    }

    private static String parseSettingsXml(File settingsXml) throws IOException, SAXException {
        if (!settingsXml.exists()) {
            return null;
        }
        XMLReader reader = XMLReaderFactory.createXMLReader();
        SettingsXmlContentHandler settingsXmlContentHandler = new SettingsXmlContentHandler();
        reader.setContentHandler(settingsXmlContentHandler);
        InputSource source = new InputSource(new FileReader(settingsXml));
        reader.parse(source);
        return settingsXmlContentHandler.getRepositoryLocation();
    }

    private static class SettingsXmlContentHandler
    implements ContentHandler {
        private String repositoryLocation;
        private String currentValue;

        private SettingsXmlContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentValue = new String(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("localRepository")) {
                this.repositoryLocation = this.currentValue;
            }
        }

        public String getRepositoryLocation() {
            return this.repositoryLocation;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }
}

