/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class BundleDelegatingClassLoader
extends ClassLoader
implements BundleReference {
    private final Bundle _bundle;
    private volatile ClassLoader _bundleClassLoader;

    public BundleDelegatingClassLoader(Bundle bundle) {
        super(null);
        this._bundle = bundle;
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        BundleReference bundleRef;
        ClassLoader cl = this._bundleClassLoader;
        if (cl != null) {
            Class<?> clazz = cl.loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        Class clazz = this._bundle.loadClass(name);
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof BundleReference && this._bundle.equals((Object)(bundleRef = (BundleReference)classLoader).getBundle())) {
            this._bundleClassLoader = classLoader;
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader cl = this._bundleClassLoader;
        if (cl != null) {
            return cl.getResource(name);
        }
        return this._bundle.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader cl = this._bundleClassLoader;
        if (cl != null) {
            return cl.getResources(name);
        }
        return this._bundle.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        ClassLoader cl = this._bundleClassLoader;
        if (cl != null) {
            return cl.getResourceAsStream(name);
        }
        URL url = this.getResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public ClassLoader getBundleClassLoader() {
        return this._bundleClassLoader;
    }

    public String toString() {
        return String.format("%s[bundle=%s]", this.getClass().getSimpleName(), this._bundle.getSymbolicName());
    }
}

