/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.osgi.AbstractContextProvider;
import org.eclipse.jetty.osgi.BundleMetadata;
import org.eclipse.jetty.osgi.BundleProvider;
import org.eclipse.jetty.osgi.ContextFactory;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleContextProvider
extends AbstractContextProvider
implements BundleProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BundleContextProvider.class);
    private final Map<Bundle, List<ContextHandler>> _bundleMap = new HashMap<Bundle, List<ContextHandler>>();
    private ServiceRegistration<?> _serviceRegForBundles;
    private BundleTracker<Object> _tracker;

    public BundleContextProvider(Server server, Deployer deployer, String environment, ContextFactory contextFactory) {
        super(server, deployer, environment, contextFactory);
    }

    protected void doStart() throws Exception {
        String serverName = (String)this.getServer().getAttribute("managedServerName");
        this._tracker = new ContextBundleTracker(FrameworkUtil.getBundle(this.getClass()).getBundleContext(), serverName);
        this._tracker.open();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", serverName);
        this._serviceRegForBundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(BundleProvider.class.getName(), (Object)this, properties);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._tracker.close();
        if (this._serviceRegForBundles != null) {
            try {
                this._serviceRegForBundles.unregister();
            }
            catch (Exception e) {
                LOG.warn("Unable to unregister {}", this._serviceRegForBundles, (Object)e);
            }
        }
    }

    @Override
    public boolean bundleAdded(Bundle bundle) throws Exception {
        String[] tmp;
        if (bundle == null) {
            return false;
        }
        if (!this.isDeployable(bundle)) {
            return false;
        }
        if (bundle.getHeaders().get("Web-ContextPath") != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("BundleContextProvider ignoring bundle {} with {} set", (Object)bundle.getSymbolicName(), (Object)"Web-ContextPath");
            }
            return false;
        }
        String contextFiles = (String)bundle.getHeaders().get("Jetty-ContextFilePath");
        if (contextFiles == null) {
            return false;
        }
        String jettyHome = (String)this.getServer().getAttribute("jetty.home");
        Path jettyHomePath = StringUtil.isBlank((String)jettyHome) ? null : Paths.get(jettyHome, new String[0]);
        boolean added = false;
        for (String contextFile : tmp = contextFiles.split("[,;]")) {
            BundleMetadata metadata = new BundleMetadata(bundle);
            URI contextFilePath = Util.resolvePathAsLocalizedURI(contextFile, metadata.getBundle(), jettyHomePath);
            if (contextFilePath != null) {
                metadata.getAttributes().setAttribute("Jetty-ContextFilePath", (Object)contextFilePath.toASCIIString());
            }
            ContextHandler contextHandler = this.createContextHandler(metadata);
            List contextHandlers = this._bundleMap.computeIfAbsent(bundle, b -> new ArrayList());
            contextHandlers.add(contextHandler);
            this.getContextHandlerManagement().deploy(contextHandler);
            added = true;
        }
        return added;
    }

    @Override
    public boolean bundleRemoved(Bundle bundle) {
        List<ContextHandler> contexts = this._bundleMap.remove(bundle);
        if (contexts == null || contexts.isEmpty()) {
            return false;
        }
        boolean removed = false;
        for (ContextHandler context : contexts) {
            this.getContextHandlerManagement().undeploy(context);
            removed = true;
        }
        return removed;
    }

    public class ContextBundleTracker
    extends BundleTracker<Object> {
        protected String _serverName;

        public ContextBundleTracker(BundleContext bundleContext, String serverName) {
            super(bundleContext, 48, null);
            this._serverName = serverName;
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            try {
                String serverName = (String)bundle.getHeaders().get("managedServerName");
                if ((StringUtil.isBlank((String)serverName) && this._serverName.equals("defaultJettyServer") || !StringUtil.isBlank((String)serverName) && serverName.equals(this._serverName)) && BundleContextProvider.this.bundleAdded(bundle)) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to add bundle {}", (Object)bundle, (Object)e);
            }
            return null;
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            try {
                BundleContextProvider.this.bundleRemoved(bundle);
            }
            catch (Exception e) {
                LOG.warn("Unable to remove bundle {}", (Object)bundle, (Object)e);
            }
        }
    }
}

