/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.BasicAuthentication;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.FormRequestContent;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.security.openid.JwtDecoder;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdCredentials
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdCredentials.class);
    private static final long serialVersionUID = 4766053233370044796L;
    private final String redirectUri;
    private String authCode;
    private Map<String, Object> response;
    private Map<String, Object> claims;
    private Fields errorFields;

    public OpenIdCredentials(Map<String, Object> claims) {
        this.redirectUri = null;
        this.authCode = null;
        this.claims = claims;
    }

    public OpenIdCredentials(String authCode, String redirectUri) {
        this.authCode = authCode;
        this.redirectUri = redirectUri;
    }

    public String getUserId() {
        return (String)this.claims.get("sub");
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public Map<String, Object> getResponse() {
        return this.response;
    }

    public Fields getErrorFields() {
        return this.errorFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeemAuthCode(OpenIdConfiguration configuration) {
        if (this.authCode != null) {
            try {
                this.response = this.claimAuthCode(configuration);
                String errorCode = (String)this.response.get("error");
                if (errorCode != null) {
                    String errorDescription = (String)this.response.get("error_description");
                    String errorUri = (String)this.response.get("error_uri");
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append("auth failed: ").append(errorCode);
                    if (errorDescription != null) {
                        errorMessage.append(" - ").append(errorDescription);
                    }
                    this.errorFields = new Fields();
                    this.errorFields.put("error_description_jetty", errorMessage.toString());
                    this.errorFields.put("error", errorCode);
                    if (errorDescription != null) {
                        this.errorFields.put("error_description", errorDescription);
                    }
                    if (errorUri != null) {
                        this.errorFields.put("error_uri", errorUri);
                    }
                    return;
                }
                String idToken = (String)this.response.get("id_token");
                if (idToken == null) {
                    throw new AuthenticationException("no id_token");
                }
                String accessToken = (String)this.response.get("access_token");
                if (accessToken == null) {
                    throw new AuthenticationException("no access_token");
                }
                String tokenType = (String)this.response.get("token_type");
                if (!"Bearer".equalsIgnoreCase(tokenType)) {
                    throw new AuthenticationException("invalid token_type");
                }
                this.claims = JwtDecoder.decode(idToken);
                this.validateClaims(configuration);
            }
            catch (Throwable t) {
                this.errorFields = new Fields();
                this.errorFields.put("error_description_jetty", t.getMessage());
            }
            finally {
                this.authCode = null;
            }
        }
    }

    private void validateClaims(OpenIdConfiguration configuration) throws Exception {
        if (!configuration.getIssuer().equals(this.claims.get("iss"))) {
            throw new AuthenticationException("Issuer Identifier MUST exactly match the iss Claim");
        }
        this.validateAudience(configuration);
        Object azp = this.claims.get("azp");
        if (azp != null && !configuration.getClientId().equals(azp)) {
            throw new AuthenticationException("Authorized party claim value should be the client_id");
        }
        if (this.isExpired()) {
            throw new AuthenticationException("ID Token has expired");
        }
    }

    public boolean isExpired() {
        return OpenIdCredentials.checkExpiry(this.claims);
    }

    public static boolean checkExpiry(Map<String, Object> claims) {
        if (claims == null) {
            return true;
        }
        return Instant.ofEpochSecond((Long)claims.get("exp")).isBefore(Instant.now());
    }

    private void validateAudience(OpenIdConfiguration configuration) throws AuthenticationException {
        boolean isValidType;
        Object aud = this.claims.get("aud");
        String clientId = configuration.getClientId();
        boolean isString = aud instanceof String;
        boolean isList = aud instanceof Object[];
        boolean bl = isValidType = isString || isList;
        if (isString && !clientId.equals(aud)) {
            throw new AuthenticationException("Audience Claim MUST contain the client_id value");
        }
        if (isList) {
            List<Object> list = Arrays.asList((Object[])aud);
            if (!list.contains(clientId)) {
                throw new AuthenticationException("Audience Claim MUST contain the client_id value");
            }
            if (list.size() > 1 && this.claims.get("azp") == null) {
                throw new AuthenticationException("A multi-audience ID token needs to contain an azp claim");
            }
        } else if (!isValidType) {
            throw new AuthenticationException("Audience claim was not valid");
        }
    }

    private Map<String, Object> claimAuthCode(OpenIdConfiguration configuration) throws Exception {
        Fields fields = new Fields();
        fields.add("code", this.authCode);
        fields.add("redirect_uri", this.redirectUri);
        fields.add("grant_type", "authorization_code");
        Request request = configuration.getHttpClient().POST(configuration.getTokenEndpoint());
        switch (configuration.getAuthenticationMethod()) {
            case "client_secret_basic": {
                URI uri = URI.create(configuration.getTokenEndpoint());
                BasicAuthentication.BasicResult authentication = new BasicAuthentication.BasicResult(uri, configuration.getClientId(), configuration.getClientSecret());
                authentication.apply(request);
                break;
            }
            case "client_secret_post": {
                fields.add("client_id", configuration.getClientId());
                fields.add("client_secret", configuration.getClientSecret());
                break;
            }
            default: {
                throw new IllegalStateException(configuration.getAuthenticationMethod());
            }
        }
        FormRequestContent formContent = new FormRequestContent(fields);
        request = request.body((Request.Content)formContent).timeout(10L, TimeUnit.SECONDS);
        ContentResponse response = request.send();
        String responseBody = response.getContentAsString();
        Object parsedResponse = new JSON().fromJSON((CharSequence)responseBody);
        if (!(parsedResponse instanceof Map)) {
            throw new AuthenticationException("Malformed response from OpenID Provider");
        }
        return (Map)parsedResponse;
    }

    public static class AuthenticationException
    extends Exception {
        public AuthenticationException(String message) {
            super(message);
        }
    }
}

