/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(JwtDecoder.class);

    public static Map<String, Object> decode(String jwt) {
        Object parsedClaims;
        String[] sections = jwt.split("\\.");
        if (sections.length != 3) {
            throw new IllegalArgumentException("JWT does not contain 3 sections");
        }
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String jwtHeaderString = new String(decoder.decode(JwtDecoder.padJWTSection(sections[0])), StandardCharsets.UTF_8);
        String jwtClaimString = new String(decoder.decode(JwtDecoder.padJWTSection(sections[1])), StandardCharsets.UTF_8);
        String jwtSignature = sections[2];
        JSON json = new JSON();
        Object parsedJwtHeader = json.fromJSON((CharSequence)jwtHeaderString);
        if (!(parsedJwtHeader instanceof Map)) {
            throw new IllegalStateException("Invalid JWT header");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("JWT signature not validated {}", (Object)jwtSignature);
        }
        if (!((parsedClaims = json.fromJSON((CharSequence)jwtClaimString)) instanceof Map)) {
            throw new IllegalStateException("Could not decode JSON for JWT claims.");
        }
        return (Map)parsedClaims;
    }

    static byte[] padJWTSection(String unpaddedEncodedJwtSection) {
        byte[] paddedEncodedJwtSection;
        if (unpaddedEncodedJwtSection.endsWith("=")) {
            return unpaddedEncodedJwtSection.getBytes();
        }
        int length = unpaddedEncodedJwtSection.length();
        int remainder = length % 4;
        if (remainder == 1) {
            throw new IllegalArgumentException("Not a valid Base64-encoded string");
        }
        if (remainder > 0) {
            int paddingNeeded = (4 - remainder) % 4;
            paddedEncodedJwtSection = Arrays.copyOf(unpaddedEncodedJwtSection.getBytes(), length + paddingNeeded);
            Arrays.fill(paddedEncodedJwtSection, length, paddedEncodedJwtSection.length, (byte)61);
        } else {
            paddedEncodedJwtSection = unpaddedEncodedJwtSection.getBytes();
        }
        return paddedEncodedJwtSection;
    }
}

