/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.openid;

import java.security.Principal;
import java.util.Objects;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdCredentials;
import org.eclipse.jetty.security.openid.OpenIdUserPrincipal;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdLoginService
extends ContainerLifeCycle
implements LoginService {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdLoginService.class);
    private final OpenIdConfiguration configuration;
    private final LoginService loginService;
    private IdentityService identityService;
    private boolean authenticateNewUsers;

    public OpenIdLoginService(OpenIdConfiguration configuration) {
        this(configuration, null);
    }

    public OpenIdLoginService(OpenIdConfiguration configuration, LoginService loginService) {
        this.configuration = Objects.requireNonNull(configuration);
        this.loginService = loginService;
        this.installBean((Object)this.configuration);
        this.installBean(this.loginService);
        this.setAuthenticateNewUsers(configuration.isAuthenticateNewUsers());
    }

    public String getName() {
        return this.configuration.getIssuer();
    }

    public OpenIdConfiguration getConfiguration() {
        return this.configuration;
    }

    public UserIdentity login(String identifier, Object credentials, Request request, Function<Boolean, Session> getOrCreateSession) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("login({}, {}, {})", new Object[]{identifier, credentials, getOrCreateSession});
        }
        OpenIdCredentials openIdCredentials = (OpenIdCredentials)credentials;
        OpenIdUserPrincipal userPrincipal = new OpenIdUserPrincipal(openIdCredentials);
        Subject subject = new Subject();
        subject.getPrincipals().add(userPrincipal);
        subject.getPrivateCredentials().add(credentials);
        subject.setReadOnly();
        if (this.loginService != null) {
            return this.loginService.getUserIdentity(subject, (Principal)userPrincipal, this.isAuthenticateNewUsers());
        }
        return this.identityService.newUserIdentity(subject, (Principal)userPrincipal, new String[0]);
    }

    public boolean isAuthenticateNewUsers() {
        return this.authenticateNewUsers;
    }

    public void setAuthenticateNewUsers(boolean authenticateNewUsers) {
        this.authenticateNewUsers = authenticateNewUsers;
    }

    public boolean validate(UserIdentity user) {
        Principal principal = user.getUserPrincipal();
        if (!(principal instanceof OpenIdUserPrincipal)) {
            return false;
        }
        OpenIdUserPrincipal userPrincipal = (OpenIdUserPrincipal)principal;
        if (this.configuration.isLogoutWhenIdTokenIsExpired() && userPrincipal.getCredentials().isExpired()) {
            return false;
        }
        return this.loginService == null || this.loginService.validate(user);
    }

    public IdentityService getIdentityService() {
        return this.loginService == null ? this.identityService : this.loginService.getIdentityService();
    }

    public void setIdentityService(IdentityService service) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        if (this.loginService != null) {
            this.loginService.setIdentityService(service);
        } else {
            this.identityService = service;
        }
    }

    public void logout(UserIdentity user) {
        if (this.loginService != null) {
            this.loginService.logout(user);
        }
    }
}

