/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nested;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.nested.NestedConnector;
import org.eclipse.jetty.nested.NestedEndPoint;
import org.eclipse.jetty.nested.NestedGenerator;
import org.eclipse.jetty.nested.NestedParser;
import org.eclipse.jetty.nested.NestedRequest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;

public class NestedConnection
extends HttpConnection {
    protected NestedConnection(NestedConnector connector, NestedEndPoint endp, HttpServletRequest request, HttpServletResponse response, String nestedIn) throws IOException {
        super((Connector)connector, (EndPoint)endp, connector.getServer(), (Parser)new NestedParser(), (Generator)new NestedGenerator(connector.getResponseBuffers(), (EndPoint)endp, response, nestedIn), (Request)new NestedRequest());
        ((NestedRequest)this._request).setConnection(this);
        this._request.setScheme(request.getScheme());
        this._request.setMethod(request.getMethod());
        String uri = request.getQueryString() == null ? request.getRequestURI() : request.getRequestURI() + "?" + request.getQueryString();
        this._request.setUri(new HttpURI(uri));
        this._request.setPathInfo(request.getRequestURI());
        this._request.setQueryString(request.getQueryString());
        this._request.setProtocol(request.getProtocol());
        HttpFields fields = this.getRequestFields();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            String value = request.getHeader(header);
            fields.add(header, value);
        }
        this._request.setCookies(request.getCookies());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void service() throws IOException, ServletException {
        NestedConnection.setCurrentConnection((HttpConnection)this);
        try {
            this.getServer().handle((HttpConnection)this);
            this.completeResponse();
            this._generator.flushBuffer();
            this._endp.flush();
        }
        finally {
            NestedConnection.setCurrentConnection(null);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        return ((NestedEndPoint)this._endp).getServletInputStream();
    }

    public Connection handle() throws IOException {
        throw new IllegalStateException();
    }
}

