/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.maven.plugin.AbstractJettyMojo;
import org.eclipse.jetty.maven.plugin.Overlay;
import org.eclipse.jetty.maven.plugin.OverlayConfig;
import org.eclipse.jetty.maven.plugin.ScanPattern;
import org.eclipse.jetty.maven.plugin.ScanTargetPattern;
import org.eclipse.jetty.maven.plugin.SelectiveJarResource;
import org.eclipse.jetty.maven.plugin.WarPluginInfo;
import org.eclipse.jetty.util.PathWatcher;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class JettyRunMojo
extends AbstractJettyMojo {
    public static final String DEFAULT_WEBAPP_SRC = "src" + File.separator + "main" + File.separator + "webapp";
    public static final String FAKE_WEBAPP = "webapp-tmp";
    @Parameter(alias="useTestClasspath", defaultValue="false")
    protected boolean useTestScope;
    @Parameter(defaultValue="${maven.war.webxml}", readonly=true)
    protected String webXml;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classesDirectory;
    @Parameter
    protected ScanPattern scanClassesPattern;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    protected File testClassesDirectory;
    @Parameter
    protected ScanPattern scanTestClassesPattern;
    @Parameter(defaultValue="${maven.war.src}")
    protected File webAppSourceDirectory;
    @Parameter
    protected File[] scanTargets;
    @Parameter
    protected ScanTargetPattern[] scanTargetPatterns;
    protected WarPluginInfo warPluginInfo;
    protected List<Artifact> warArtifacts;
    protected Resource originalBaseResource;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.warPluginInfo = new WarPluginInfo(this.project);
        super.execute();
    }

    @Override
    public boolean checkPomConfiguration() throws MojoExecutionException {
        try {
            if (this.webAppSourceDirectory == null || !this.webAppSourceDirectory.exists()) {
                this.getLog().info((CharSequence)("webAppSourceDirectory" + (this.webAppSourceDirectory == null ? " not set." : this.webAppSourceDirectory.getAbsolutePath() + " does not exist.") + " Trying " + DEFAULT_WEBAPP_SRC));
                this.webAppSourceDirectory = new File(this.project.getBasedir(), DEFAULT_WEBAPP_SRC);
                if (!this.webAppSourceDirectory.exists()) {
                    this.getLog().info((CharSequence)("webAppSourceDirectory " + this.webAppSourceDirectory.getAbsolutePath() + " does not exist. Trying " + this.project.getBuild().getDirectory() + File.separator + FAKE_WEBAPP));
                    File target = new File(this.project.getBuild().getDirectory());
                    this.webAppSourceDirectory = new File(target, FAKE_WEBAPP);
                    if (!this.webAppSourceDirectory.exists()) {
                        this.webAppSourceDirectory.mkdirs();
                    }
                }
            } else {
                this.getLog().info((CharSequence)("Webapp source directory = " + this.webAppSourceDirectory.getCanonicalPath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Webapp source directory does not exist", (Exception)e);
        }
        if (!"automatic".equalsIgnoreCase(this.reload) && !"manual".equalsIgnoreCase(this.reload)) {
            throw new MojoExecutionException("invalid reload mechanic specified, must be 'automatic' or 'manual'");
        }
        this.getLog().info((CharSequence)("Reload Mechanic: " + this.reload));
        this.getLog().info((CharSequence)("nonBlocking:" + this.nonBlocking));
        try {
            if (this.classesDirectory != null) {
                if (!this.classesDirectory.exists()) {
                    this.getLog().info((CharSequence)("Classes directory " + this.classesDirectory.getCanonicalPath() + " does not exist"));
                } else {
                    this.getLog().info((CharSequence)("Classes = " + this.classesDirectory.getCanonicalPath()));
                }
            } else {
                this.getLog().info((CharSequence)"Classes directory not set");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Location of classesDirectory does not exist");
        }
        return true;
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        this.server.setStopAtShutdown(true);
        super.finishConfigurationBeforeStart();
    }

    @Override
    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        Resource webAppSourceDirectoryResource = Resource.newResource((String)this.webAppSourceDirectory.getCanonicalPath());
        if (this.webApp.getWar() == null) {
            this.webApp.setWar(webAppSourceDirectoryResource.toString());
        }
        if (this.originalBaseResource == null) {
            this.originalBaseResource = this.webApp.getBaseResource() == null ? webAppSourceDirectoryResource : this.webApp.getBaseResource();
        }
        this.webApp.setBaseResource(this.originalBaseResource);
        if (this.classesDirectory != null) {
            this.webApp.setClasses(this.classesDirectory);
        }
        if (this.useTestScope && this.testClassesDirectory != null) {
            this.webApp.setTestClasses(this.testClassesDirectory);
        }
        this.webApp.setWebInfLib(this.getDependencyFiles());
        if (this.webApp.getDescriptor() == null) {
            File f;
            Resource r;
            if (this.webXml != null && (r = Resource.newResource((String)this.webXml)).exists() && !r.isDirectory()) {
                this.webApp.setDescriptor(r.toString());
            }
            if (this.webApp.getDescriptor() == null && this.webApp.getBaseResource() != null && (r = this.webApp.getBaseResource().addPath("WEB-INF/web.xml")).exists() && !r.isDirectory()) {
                this.webApp.setDescriptor(r.toString());
            }
            if (this.webApp.getDescriptor() == null && this.webAppSourceDirectory != null && (f = new File(new File(this.webAppSourceDirectory, "WEB-INF"), "web.xml")).exists() && f.isFile()) {
                this.webApp.setDescriptor(f.getCanonicalPath());
            }
        }
        List<Overlay> overlays = this.getOverlays();
        this.unpackOverlays(overlays);
        this.getLog().info((CharSequence)("web.xml file = " + this.webApp.getDescriptor()));
        this.getLog().info((CharSequence)("Webapp directory = " + this.webAppSourceDirectory.getCanonicalPath()));
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
        try {
            this.gatherScannables();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error forming scan list", e);
        }
        this.scanner.addListener((EventListener)new PathWatcher.EventListListener(){

            public void onPathWatchEvents(List<PathWatcher.PathWatchEvent> events) {
                try {
                    boolean reconfigure = false;
                    if (events != null) {
                        for (PathWatcher.PathWatchEvent e : events) {
                            if (!e.getPath().equals(JettyRunMojo.this.project.getFile().toPath())) continue;
                            reconfigure = true;
                            break;
                        }
                    }
                    JettyRunMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
    }

    public void gatherScannables() throws Exception {
        PathWatcher.Config config;
        PathWatcher.Config config2;
        File jettyWebXmlFile;
        if (this.webApp.getDescriptor() != null) {
            Resource r = Resource.newResource((String)this.webApp.getDescriptor());
            this.scanner.watch(r.getFile().toPath());
        }
        if (this.webApp.getJettyEnvXml() != null) {
            this.scanner.watch(new File(this.webApp.getJettyEnvXml()).toPath());
        }
        if (this.webApp.getDefaultsDescriptor() != null && !"org/eclipse/jetty/webapp/webdefault.xml".equals(this.webApp.getDefaultsDescriptor())) {
            this.scanner.watch(new File(this.webApp.getDefaultsDescriptor()).toPath());
        }
        if (this.webApp.getOverrideDescriptor() != null) {
            this.scanner.watch(new File(this.webApp.getOverrideDescriptor()).toPath());
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(new File(this.webAppSourceDirectory, "WEB-INF"))) != null) {
            this.scanner.watch(jettyWebXmlFile.toPath());
        }
        for (Artifact a : this.getWarArtifacts()) {
            this.scanner.watch(a.getFile().toPath());
        }
        if (this.scanTargets != null) {
            for (File f : this.scanTargets) {
                if (f.isDirectory()) {
                    config2 = new PathWatcher.Config(f.toPath());
                    config2.setRecurseDepth(-9999);
                    this.scanner.watch(config2);
                    continue;
                }
                this.scanner.watch(f.toPath());
            }
        }
        if (this.scanTargetPatterns != null) {
            for (ScanTargetPattern p : this.scanTargetPatterns) {
                config2 = new PathWatcher.Config(p.getDirectory().toPath());
                config2.setRecurseDepth(-9999);
                for (String pattern : p.getExcludes()) {
                    config2.addExcludeGlobRelative(pattern);
                }
                for (String pattern : p.getIncludes()) {
                    config2.addIncludeGlobRelative(pattern);
                }
                this.scanner.watch(config2);
            }
        }
        this.scanner.watch(this.project.getFile().toPath());
        if (this.webApp.getTestClasses() != null && this.webApp.getTestClasses().exists()) {
            config = new PathWatcher.Config(this.webApp.getTestClasses().toPath());
            config.setRecurseDepth(-9999);
            if (this.scanTestClassesPattern != null) {
                for (String p : this.scanTestClassesPattern.getExcludes()) {
                    config.addExcludeGlobRelative(p);
                }
                for (String p : this.scanTestClassesPattern.getIncludes()) {
                    config.addIncludeGlobRelative(p);
                }
            }
            this.scanner.watch(config);
        }
        if (this.webApp.getClasses() != null && this.webApp.getClasses().exists()) {
            config = new PathWatcher.Config(this.webApp.getClasses().toPath());
            config.setRecurseDepth(-9999);
            if (this.scanClassesPattern != null) {
                for (String p : this.scanClassesPattern.getExcludes()) {
                    config.addExcludeGlobRelative(p);
                }
                for (String p : this.scanClassesPattern.getIncludes()) {
                    config.addIncludeGlobRelative(p);
                }
            }
            this.scanner.watch(config);
        }
        if (this.webApp.getWebInfLib() != null) {
            for (File f : this.webApp.getWebInfLib()) {
                PathWatcher.Config config3 = new PathWatcher.Config(f.toPath());
                config3.setRecurseDepth(-9999);
                this.scanner.watch(config3);
            }
        }
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)("restarting " + (Object)((Object)this.webApp)));
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.stopScanner();
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        this.configureWebApplication();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanner.reset();
            this.warArtifacts = null;
            this.configureScanner();
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.startScanner();
        this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
    }

    private List<File> getDependencyFiles() {
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        for (Artifact artifact : this.projectArtifacts) {
            if (artifact.getType().equals("war")) continue;
            MavenProject mavenProject = this.getProjectReference(artifact, this.project);
            if (mavenProject != null) {
                File projectPath = Paths.get(mavenProject.getBuild().getOutputDirectory(), new String[0]).toFile();
                this.getLog().debug((CharSequence)("Adding project directory " + projectPath.toString()));
                dependencyFiles.add(projectPath);
                continue;
            }
            if ("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()) && !this.useTestScope) continue;
            dependencyFiles.add(artifact.getFile());
            this.getLog().debug((CharSequence)("Adding artifact " + artifact.getFile().getName() + " with scope " + artifact.getScope() + " for WEB-INF/lib "));
        }
        return dependencyFiles;
    }

    protected MavenProject getProjectReference(Artifact artifact, MavenProject project) {
        if (project.getProjectReferences() == null || project.getProjectReferences().isEmpty()) {
            return null;
        }
        Collection mavenProjects = project.getProjectReferences().values();
        for (MavenProject mavenProject : mavenProjects) {
            if (!StringUtils.equals((String)mavenProject.getId(), (String)artifact.getId())) continue;
            return mavenProject;
        }
        return null;
    }

    private List<Overlay> getOverlays() throws Exception {
        Overlay overlay;
        HashSet<Artifact> matchedWarArtifacts = new HashSet<Artifact>();
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (OverlayConfig config : this.warPluginInfo.getMavenWarOverlayConfigs()) {
            if (config.isSkip()) continue;
            if (config.isCurrentProject()) {
                overlay = new Overlay(config, null);
                overlays.add(overlay);
                continue;
            }
            Artifact a = this.getArtifactForOverlay(config, this.getWarArtifacts());
            if (a == null) continue;
            matchedWarArtifacts.add(a);
            SelectiveJarResource r = new SelectiveJarResource(new URL("jar:" + Resource.toURL((File)a.getFile()).toString() + "!/"));
            r.setIncludes(config.getIncludes());
            r.setExcludes(config.getExcludes());
            Overlay overlay2 = new Overlay(config, (Resource)r);
            overlays.add(overlay2);
        }
        for (Artifact a : this.getWarArtifacts()) {
            if (matchedWarArtifacts.contains(a)) continue;
            overlay = new Overlay(null, Resource.newResource((URL)new URL("jar:" + Resource.toURL((File)a.getFile()).toString() + "!/")));
            overlays.add(overlay);
        }
        return overlays;
    }

    public void unpackOverlays(List<Overlay> overlays) throws Exception {
        if (overlays == null || overlays.isEmpty()) {
            return;
        }
        ArrayList<Resource> resourceBaseCollection = new ArrayList<Resource>();
        for (Overlay o : overlays) {
            if (o.getConfig() != null && o.getConfig().isCurrentProject() && this.webApp.getBaseResource().exists()) {
                resourceBaseCollection.add(this.webApp.getBaseResource());
                continue;
            }
            Resource unpacked = this.unpackOverlay(o);
            resourceBaseCollection.add(unpacked);
        }
        if (!resourceBaseCollection.contains(this.webApp.getBaseResource()) && this.webApp.getBaseResource().exists()) {
            if (this.webApp.getBaseAppFirst()) {
                resourceBaseCollection.add(0, this.webApp.getBaseResource());
            } else {
                resourceBaseCollection.add(this.webApp.getBaseResource());
            }
        }
        this.webApp.setBaseResource((Resource)new ResourceCollection(resourceBaseCollection.toArray(new Resource[resourceBaseCollection.size()])));
    }

    public Resource unpackOverlay(Overlay overlay) throws IOException {
        File dir;
        int i;
        if (overlay.getResource() == null) {
            return null;
        }
        String name = overlay.getResource().getName();
        if (name.endsWith("!/")) {
            name = name.substring(0, name.length() - 2);
        }
        if ((i = name.lastIndexOf(47)) > 0) {
            name = name.substring(i + 1, name.length());
        }
        name = name.replace('.', '_');
        File overlaysDir = new File(this.project.getBuild().getDirectory(), "jetty_overlays");
        File unpackDir = dir = new File(overlaysDir, name);
        if (overlay.getConfig() != null && overlay.getConfig().getTargetPath() != null) {
            unpackDir = new File(dir, overlay.getConfig().getTargetPath());
        }
        if (!unpackDir.exists() || overlay.getResource().lastModified() > unpackDir.lastModified()) {
            boolean made = unpackDir.mkdirs();
            overlay.getResource().copyTo(unpackDir);
        }
        return Resource.newResource((String)dir.getCanonicalPath());
    }

    private List<Artifact> getWarArtifacts() {
        if (this.warArtifacts != null) {
            return this.warArtifacts;
        }
        this.warArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : this.projectArtifacts) {
            if (!artifact.getType().equals("war") && !artifact.getType().equals("zip")) continue;
            try {
                this.warArtifacts.add(artifact);
                this.getLog().info((CharSequence)("Dependent war artifact " + artifact.getId()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.warArtifacts;
    }

    protected Artifact getArtifactForOverlay(OverlayConfig o, List<Artifact> warArtifacts) {
        if (o == null || warArtifacts == null || warArtifacts.isEmpty()) {
            return null;
        }
        for (Artifact a : warArtifacts) {
            if (!o.matchesArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier())) continue;
            return a;
        }
        return null;
    }
}

