/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.maven.plugin.MavenServerConnector;
import org.eclipse.jetty.maven.plugin.PluginLog;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class ServerSupport {
    public static void configureDefaultConfigurationClasses(Server server) {
        server.setAttribute("org.eclipse.jetty.webapp.configuration", (Object)JettyWebAppContext.DEFAULT_CONFIGURATION_CLASSES);
    }

    public static void configureHandlers(Server server, RequestLog requestLog) throws Exception {
        ContextHandlerCollection contexts;
        if (server == null) {
            throw new IllegalArgumentException("Server is null");
        }
        DefaultHandler defaultHandler = new DefaultHandler();
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        if (requestLog != null) {
            requestLogHandler.setRequestLog(requestLog);
        }
        if ((contexts = ServerSupport.findContextHandlerCollection(server)) == null) {
            contexts = new ContextHandlerCollection();
            HandlerCollection handlers = (HandlerCollection)server.getChildHandlerByClass(HandlerCollection.class);
            if (handlers == null) {
                handlers = new HandlerCollection();
                server.setHandler((Handler)handlers);
                handlers.setHandlers(new Handler[]{contexts, defaultHandler, requestLogHandler});
            } else {
                handlers.addHandler((Handler)contexts);
            }
        }
    }

    public static void configureConnectors(Server server, Connector connector) {
        if (server == null) {
            throw new IllegalArgumentException("Server is null");
        }
        if (connector != null) {
            server.addConnector(connector);
            return;
        }
        Connector[] connectors = server.getConnectors();
        if (connectors == null || connectors.length == 0) {
            MavenServerConnector tmp = new MavenServerConnector();
            String port = System.getProperty(MavenServerConnector.PORT_SYSPROPERTY, System.getProperty("jetty.port", MavenServerConnector.DEFAULT_PORT_STR));
            tmp.setPort(Integer.parseInt(port.trim()));
            tmp.setServer(server);
            server.setConnectors(new Connector[]{tmp});
        }
    }

    public static void configureLoginServices(Server server, LoginService[] loginServices) {
        if (server == null) {
            throw new IllegalArgumentException("Server is null");
        }
        if (loginServices != null) {
            for (LoginService loginService : loginServices) {
                PluginLog.getLog().debug((CharSequence)(loginService.getClass().getName() + ": " + loginService.toString()));
                server.addBean((Object)loginService);
            }
        }
    }

    public static void addWebApplication(Server server, WebAppContext webapp) throws Exception {
        if (server == null) {
            throw new IllegalArgumentException("Server is null");
        }
        ContextHandlerCollection contexts = ServerSupport.findContextHandlerCollection(server);
        if (contexts == null) {
            throw new IllegalStateException("ContextHandlerCollection is null");
        }
        contexts.addHandler((Handler)webapp);
    }

    public static ContextHandlerCollection findContextHandlerCollection(Server server) {
        if (server == null) {
            return null;
        }
        return (ContextHandlerCollection)server.getChildHandlerByClass(ContextHandlerCollection.class);
    }

    public static Server applyXmlConfigurations(Server server, List<File> files) throws Exception {
        if (files == null || files.isEmpty()) {
            return server;
        }
        Map<String, Object> lastMap = new HashMap<String, Server>();
        if (server != null) {
            lastMap.put("Server", server);
        }
        for (File xmlFile : files) {
            if (PluginLog.getLog() != null) {
                PluginLog.getLog().info((CharSequence)("Configuring Jetty from xml configuration file = " + xmlFile.getCanonicalPath()));
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)xmlFile));
            if (lastMap != null) {
                xmlConfiguration.getIdMap().putAll(lastMap);
            }
            Enumeration<?> ensysprop = System.getProperties().propertyNames();
            while (ensysprop.hasMoreElements()) {
                String name = (String)ensysprop.nextElement();
                xmlConfiguration.getProperties().put(name, System.getProperty(name));
            }
            xmlConfiguration.configure();
            lastMap = xmlConfiguration.getIdMap();
        }
        return (Server)lastMap.get("Server");
    }
}

