/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class MavenAnnotationConfiguration
extends AnnotationConfiguration {
    private static final Logger LOG = Log.getLogger(MavenAnnotationConfiguration.class);

    public void parseWebInfClasses(WebAppContext context, AnnotationParser parser) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() == null || jwac.getClassPathFiles().size() == 0) {
            super.parseWebInfClasses(context, parser);
        } else {
            Resource classesDir;
            LOG.debug("Scanning classes ", new Object[0]);
            MetaData metaData = context.getMetaData();
            if (metaData == null) {
                throw new IllegalStateException("No metadata");
            }
            HashSet<ClassInheritanceHandler> handlers = new HashSet<ClassInheritanceHandler>();
            handlers.addAll(this._discoverableAnnotationHandlers);
            if (this._classInheritanceHandler != null) {
                handlers.add(this._classInheritanceHandler);
            }
            handlers.addAll(this._containerInitializerAnnotationHandlers);
            for (File f : jwac.getClassPathFiles()) {
                if (!f.isDirectory() || !f.exists()) continue;
                this.doParse(handlers, context, parser, Resource.newResource((URI)f.toURI()));
            }
            if (context.getWebInf() != null && context.getWebInf().exists() && (classesDir = context.getWebInf().addPath("classes/")).exists()) {
                this.doParse(handlers, context, parser, classesDir);
            }
        }
    }

    public void doParse(Set<? extends AnnotationParser.Handler> handlers, WebAppContext context, AnnotationParser parser, Resource resource) throws Exception {
        if (this._parserTasks != null) {
            this._parserTasks.add(new AnnotationConfiguration.ParserTask((AnnotationConfiguration)this, parser, handlers, resource, (ClassNameResolver)this._webAppClassNameResolver));
        } else {
            parser.parse(handlers, resource, (ClassNameResolver)this._webAppClassNameResolver);
        }
    }
}

