/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.jetty.maven.plugin.JettyEmbedder;
import org.eclipse.jetty.util.PathWatcher;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyForkedChild
extends AbstractLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(JettyForkedChild.class);
    protected JettyEmbedder jetty = new JettyEmbedder();
    protected File tokenFile;
    protected PathWatcher scanner;
    protected File webAppPropsFile;

    public JettyForkedChild(String[] args) throws Exception {
        this.configure(args);
    }

    public void configure(String[] args) throws Exception {
        HashMap<String, String> jettyProperties = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String[] tmp;
            if ("--stop-port".equals(args[i])) {
                this.jetty.setStopPort(Integer.parseInt(args[++i]));
                continue;
            }
            if ("--stop-key".equals(args[i])) {
                this.jetty.setStopKey(args[++i]);
                continue;
            }
            if ("--jetty-xml".equals(args[i])) {
                ArrayList<File> jettyXmls = new ArrayList<File>();
                String[] names = StringUtil.csvSplit((String)args[++i]);
                for (int j = 0; names != null && j < names.length; ++j) {
                    jettyXmls.add(new File(names[j].trim()));
                }
                this.jetty.setJettyXmlFiles(jettyXmls);
                continue;
            }
            if ("--webprops".equals(args[i])) {
                this.webAppPropsFile = new File(args[++i].trim());
                this.jetty.setWebAppProperties(this.loadWebAppProps());
                continue;
            }
            if ("--token".equals(args[i])) {
                this.tokenFile = new File(args[++i].trim());
                continue;
            }
            if ("--scan".equals(args[i])) {
                this.scanner = new PathWatcher();
                this.scanner.setNotifyExistingOnStart(false);
                this.scanner.addListener((EventListener)new PathWatcher.EventListListener(){

                    public void onPathWatchEvents(List<PathWatcher.PathWatchEvent> events) {
                        if (!Objects.isNull(JettyForkedChild.this.scanner)) {
                            try {
                                JettyForkedChild.this.scanner.stop();
                                if (!Objects.isNull((Object)JettyForkedChild.this.jetty.getWebApp())) {
                                    JettyForkedChild.this.jetty.getWebApp().stop();
                                    JettyForkedChild.this.jetty.setWebAppProperties(JettyForkedChild.this.loadWebAppProps());
                                    JettyForkedChild.this.jetty.setWebApp(JettyForkedChild.this.jetty.getWebApp());
                                    JettyForkedChild.this.jetty.redeployWebApp();
                                    JettyForkedChild.this.scanner.start();
                                }
                            }
                            catch (Exception e) {
                                LOG.warn("Error restarting webapp", (Throwable)e);
                            }
                        }
                    }
                });
                if (!Objects.isNull(this.webAppPropsFile)) {
                    this.scanner.watch(this.webAppPropsFile.toPath());
                }
            }
            if ((tmp = args[i].trim().split("=")).length != 2) continue;
            jettyProperties.put(tmp[0], tmp[1]);
        }
        this.jetty.setJettyProperties(jettyProperties);
        this.jetty.setExitVm(true);
    }

    private Properties loadWebAppProps() throws FileNotFoundException, IOException {
        Properties props = new Properties();
        if (Objects.nonNull(this.webAppPropsFile)) {
            props.load(new FileInputStream(this.webAppPropsFile));
        }
        return props;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.jetty.start();
        Resource r = Resource.newResource((File)this.tokenFile);
        r.getFile().createNewFile();
        if (this.scanner != null) {
            this.scanner.start();
        }
        this.jetty.join();
    }

    public static void main(String[] args) throws Exception {
        if (args == null) {
            System.exit(1);
        }
        JettyForkedChild child = new JettyForkedChild(args);
        child.start();
    }
}

