/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.Console;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;

public class ConsoleReader
implements Runnable {
    public Set<Listener> listeners = new HashSet<Listener>();

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void run() {
        Console console = System.console();
        if (console == null) {
            return;
        }
        String line = "";
        while (line != null) {
            line = console.readLine("%nHit <enter> to redeploy:%n%n", new Object[0]);
            if (line == null) continue;
            this.signalEvent(line);
        }
    }

    private void signalEvent(String line) {
        for (Listener l : this.listeners) {
            l.consoleEvent(line);
        }
    }

    public static interface Listener
    extends EventListener {
        public void consoleEvent(String var1);
    }
}

