/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class MavenQuickStartConfiguration
extends QuickStartConfiguration {
    private static final Logger LOG = Log.getLogger(QuickStartConfiguration.class);
    private Resource _quickStartWebXml;

    public void setQuickStartWebXml(Resource quickStartWebXml) {
        this._quickStartWebXml = quickStartWebXml;
    }

    public Resource getQuickStartWebXml(WebAppContext context) throws Exception {
        if (this._quickStartWebXml == null) {
            return super.getQuickStartWebXml(context);
        }
        return this._quickStartWebXml;
    }

    public void preConfigure(WebAppContext context) throws Exception {
        if (context.getBaseResource() == null) {
            throw new IllegalStateException("No location for webapp");
        }
        Resource quickStartWebXml = this.getQuickStartWebXml(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("quickStartWebXml={}", new Object[]{quickStartWebXml});
        }
        super.preConfigure(context);
    }

    public void configure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up classpath ...", new Object[0]);
            }
            for (File classPathFile : jwac.getClassPathFiles()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classPathFile.getCanonicalPath());
            }
        }
        super.configure(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        if (!context.isPersistTempDirectory()) {
            Resource originalBases = (Resource)context.getAttribute("org.eclipse.jetty.resources.originalBases");
            String originalBaseStr = originalBases.toString();
            Resource res = context.getBaseResource();
            if (res instanceof ResourceCollection) {
                for (Resource r : ((ResourceCollection)res).getResources()) {
                    if (originalBaseStr.contains(r.toString())) continue;
                    IO.delete((File)r.getFile());
                }
            }
        }
        super.deconfigure(context);
    }
}

