/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jspc.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.eclipse.jetty:jetty-jspc-maven-plugin:9.0.0.M2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Jetty :: Jetty JSPC Maven Plugin", 0);
        this.append(sb, "Administrative parent pom for Jetty modules", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jetty-jspc:help", 0);
            this.append(sb, "Display help information on jetty-jspc-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jetty-jspc:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jspc".equals(this.goal)) {
            this.append(sb, "jetty-jspc:jspc", 0);
            this.append(sb, "This goal will compile jsps for a webapp so that they can be included in a war.\n\nAt runtime, the plugin will use the jsp2.0 jspc compiler if you are running on a 1.4 or lower jvm. If you are using a 1.5 jvm, then the jsp2.1 compiler will be selected. (this is the same behaviour as the jetty plugin for executing webapps).\n\nNote that the same java compiler will be used as for on-the-fly compiled jsps, which will be the Eclipse java compiler.\n\nSee Usage Guide for instructions on using this plugin.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The location of the compiled classes for the webapp", 3);
                this.append(sb, "Expression: ${project.build.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "The comma separated list of file name patters to exclude from compilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedClasses (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The destination directory into which to put the compiled jsps.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreJspFragmentErrors (Default: false)", 2);
                this.append(sb, "Whether or not to ignore precompilation errors caused by jsp fragments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **/*.jsp, **/*.jspx)", 2);
                this.append(sb, "The comma separated list of patterns for file extensions to be processed. By default will include all .jsp and .jspx files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "insertionMarker", 2);
                this.append(sb, "Optional. A marker string in the src web.xml file which indicates where to merge in the generated web.xml fragment. Note that the marker string will NOT be preserved during the insertion. Can be left blank, in which case the generated fragment is inserted just before the </web-app> line", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaEncoding (Default: UTF-8)", 2);
                this.append(sb, "The encoding scheme to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepSources (Default: false)", 2);
                this.append(sb, "Controls whether or not .java files generated during compilation will be preserved.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mergeFragment (Default: true)", 2);
                this.append(sb, "Merge the generated fragment file with the web.xml from webAppSourceDirectory. The merged file will go into the same directory as the webXmlFragment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageRoot (Default: jsp)", 2);
                this.append(sb, "Default root package for all generated classes", 3);
                this.append(sb, "", 0);
                this.append(sb, "schemaResourcePrefix", 2);
                this.append(sb, "Allows a prefix to be appended to the standard schema locations so that they can be loaded from elsewhere.", 3);
                this.append(sb, "", 0);
                this.append(sb, "suppressSmap (Default: true)", 2);
                this.append(sb, "Whether or not to generate JSR45 compliant debug info", 3);
                this.append(sb, "", 0);
                this.append(sb, "tldJarNamePatterns (Default: .*taglibs[^/]*.jar|.*jstl-impl[^/]*.jar$)", 2);
                this.append(sb, "Patterns of jars on the system path that contain tlds. Use | to separate each pattern.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trimSpaces", 2);
                this.append(sb, "Should white spaces in template text between actions or directives be trimmed? Defaults to false.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useProvidedScope (Default: false)", 2);
                this.append(sb, "Whether or not to include dependencies on the plugin's classpath with <scope>provided</scope> Use WITH CAUTION as you may wind up with duplicate jars/classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "validateXml (Default: false)", 2);
                this.append(sb, "If true, validates tlds when parsing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Whether or not to output more verbose messages during compilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webAppSourceDirectory (Default: ${basedir}/src/main/webapp)", 2);
                this.append(sb, "Root directory for all html/jsp etc files", 3);
                this.append(sb, "", 0);
                this.append(sb, "webXml (Default: ${basedir}/src/main/webapp/WEB-INF/web.xml)", 2);
                this.append(sb, "Location of web.xml. Defaults to src/main/webapp/web.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "webXmlFragment (Default: ${basedir}/target/webfrag.xml)", 2);
                this.append(sb, "File into which to generate the <servlet> and <servlet-mapping> tags for the compiled jsps", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

