/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HttpFieldsTest {
    @Test
    public void testPut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value:0");
        header.put("name1", "value1");
        Assert.assertEquals((long)2L, (long)header.size());
        Assert.assertEquals((Object)"value:0", (Object)header.get("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.get("name1"));
        Assert.assertNull((Object)header.get("name2"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if (!"name1".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)2L, (long)matches);
        e = header.getValues("name0");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value:0");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testPutTo() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value:A");
        header.add("name1", "value:B");
        header.add("name2", "");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String result = BufferUtil.toString((ByteBuffer)buffer);
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name0: value0"));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name1: value:A"));
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name1: value:B"));
    }

    @Test
    public void testGet() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value1");
        Assert.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assert.assertEquals((Object)"value0", (Object)header.get("Name0"));
        Assert.assertEquals((Object)"value1", (Object)header.get("name1"));
        Assert.assertEquals((Object)"value1", (Object)header.get("Name1"));
        Assert.assertEquals(null, (Object)header.get("Name2"));
        Assert.assertEquals((Object)"value0", (Object)header.getField("name0").getValue());
        Assert.assertEquals((Object)"value0", (Object)header.getField("Name0").getValue());
        Assert.assertEquals((Object)"value1", (Object)header.getField("name1").getValue());
        Assert.assertEquals((Object)"value1", (Object)header.getField("Name1").getValue());
        Assert.assertEquals(null, (Object)header.getField("Name2"));
        Assert.assertEquals((Object)"value0", (Object)header.getField(0).getValue());
        Assert.assertEquals((Object)"value1", (Object)header.getField(1).getValue());
        try {
            header.getField(2);
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testGetKnown() throws Exception {
        HttpFields header = new HttpFields();
        header.put("Connection", "value0");
        header.put(HttpHeader.ACCEPT, "value1");
        Assert.assertEquals((Object)"value0", (Object)header.get(HttpHeader.CONNECTION));
        Assert.assertEquals((Object)"value1", (Object)header.get(HttpHeader.ACCEPT));
        Assert.assertEquals((Object)"value0", (Object)header.getField(HttpHeader.CONNECTION).getValue());
        Assert.assertEquals((Object)"value1", (Object)header.getField(HttpHeader.ACCEPT).getValue());
        Assert.assertEquals(null, (Object)header.getField(HttpHeader.AGE));
        Assert.assertEquals(null, (Object)header.get(HttpHeader.AGE));
    }

    @Test
    public void testCRLF() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value\r\n0");
        header.put("name\r\n1", "value1");
        header.put("name:2", "value:\r\n2");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String out = BufferUtil.toString((ByteBuffer)buffer);
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name0: value  0"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name??1: value1"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name?2: value:  2"));
    }

    @Test
    public void testCachedPut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("Connection", "Keep-Alive");
        header.put("tRansfer-EncOding", "CHUNKED");
        header.put("CONTENT-ENCODING", "gZIP");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String out = BufferUtil.toString((ByteBuffer)buffer).toLowerCase(Locale.ENGLISH);
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.CONNECTION + ": " + HttpHeaderValue.KEEP_ALIVE).toLowerCase(Locale.ENGLISH)));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.TRANSFER_ENCODING + ": " + HttpHeaderValue.CHUNKED).toLowerCase(Locale.ENGLISH)));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.CONTENT_ENCODING + ": " + HttpHeaderValue.GZIP).toLowerCase(Locale.ENGLISH)));
    }

    @Test
    public void testRePut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "xxxxxx");
        header.put("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assert.assertEquals((Object)"xxxxxx", (Object)header.get("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.get("name2"));
        header.put("name1", "value1");
        Assert.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.get("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.get("name2"));
        Assert.assertNull((Object)header.get("name3"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            String o = (String)e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)3L, (long)matches);
        e = header.getValues("name1");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testRemovePut() throws Exception {
        HttpFields header = new HttpFields(1);
        header.put("name0", "value0");
        header.put("name1", "value1");
        header.put("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assert.assertEquals((Object)"value1", (Object)header.get("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.get("name2"));
        header.remove("name1");
        Assert.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assert.assertNull((Object)header.get("name1"));
        Assert.assertEquals((Object)"value2", (Object)header.get("name2"));
        Assert.assertNull((Object)header.get("name3"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)2L, (long)matches);
        e = header.getValues("name1");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testAdd() throws Exception {
        HttpFields fields = new HttpFields();
        fields.add("name0", "value0");
        fields.add("name1", "valueA");
        fields.add("name2", "value2");
        Assert.assertEquals((Object)"value0", (Object)fields.get("name0"));
        Assert.assertEquals((Object)"valueA", (Object)fields.get("name1"));
        Assert.assertEquals((Object)"value2", (Object)fields.get("name2"));
        fields.add("name1", "valueB");
        Assert.assertEquals((Object)"value0", (Object)fields.get("name0"));
        Assert.assertEquals((Object)"valueA", (Object)fields.get("name1"));
        Assert.assertEquals((Object)"value2", (Object)fields.get("name2"));
        Assert.assertNull((Object)fields.get("name3"));
        int matches = 0;
        Enumeration e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assert.assertEquals((long)3L, (long)matches);
        e = fields.getValues("name1");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"valueA");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"valueB");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testGetValues() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("name0", "value0A,value0B");
        fields.add("name0", "value0C,value0D");
        fields.put("name1", "value1A, \"value\t, 1B\" ");
        fields.add("name1", "\"value1C\",\tvalue1D");
        Enumeration e = fields.getValues("name0");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0A,value0B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0C,value0D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = fields.getValues("name0", ",");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0A");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0C");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = fields.getValues("name1", ",");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1A");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value\t, 1B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1C");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testGetCSV() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("name0", "value0A,value0B");
        fields.add("name0", "value0C,value0D");
        fields.put("name1", "value1A, \"value\t, 1B\" ");
        fields.add("name1", "\"value1C\",\tvalue1D");
        Enumeration e = fields.getValues("name0");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0A,value0B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0C,value0D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = Collections.enumeration(fields.getCSV("name0", false));
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0A");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0C");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value0D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = Collections.enumeration(fields.getCSV("name1", false));
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1A");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value\t, 1B");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1C");
        Assert.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assert.assertEquals(e.nextElement(), (Object)"value1D");
        Assert.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testAddQuotedCSV() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("some", "value");
        fields.add("name", "\"zero\"");
        fields.add("name", "one, \"1 + 1\"");
        fields.put("other", "value");
        fields.add("name", "three");
        fields.add("name", "four, I V");
        List list = fields.getCSV("name", false);
        Assert.assertEquals((Object)"zero", (Object)HttpFields.valueParameters((String)((String)list.get(0)), null));
        Assert.assertEquals((Object)"one", (Object)HttpFields.valueParameters((String)((String)list.get(1)), null));
        Assert.assertEquals((Object)"1 + 1", (Object)HttpFields.valueParameters((String)((String)list.get(2)), null));
        Assert.assertEquals((Object)"three", (Object)HttpFields.valueParameters((String)((String)list.get(3)), null));
        Assert.assertEquals((Object)"four", (Object)HttpFields.valueParameters((String)((String)list.get(4)), null));
        Assert.assertEquals((Object)"I V", (Object)HttpFields.valueParameters((String)((String)list.get(5)), null));
        fields.addCSV("name", new String[]{"six"});
        list = fields.getCSV("name", false);
        Assert.assertEquals((Object)"zero", (Object)HttpFields.valueParameters((String)((String)list.get(0)), null));
        Assert.assertEquals((Object)"one", (Object)HttpFields.valueParameters((String)((String)list.get(1)), null));
        Assert.assertEquals((Object)"1 + 1", (Object)HttpFields.valueParameters((String)((String)list.get(2)), null));
        Assert.assertEquals((Object)"three", (Object)HttpFields.valueParameters((String)((String)list.get(3)), null));
        Assert.assertEquals((Object)"four", (Object)HttpFields.valueParameters((String)((String)list.get(4)), null));
        Assert.assertEquals((Object)"I V", (Object)HttpFields.valueParameters((String)((String)list.get(5)), null));
        Assert.assertEquals((Object)"six", (Object)HttpFields.valueParameters((String)((String)list.get(6)), null));
        fields.addCSV("name", new String[]{"1 + 1", "7", "zero"});
        list = fields.getCSV("name", false);
        Assert.assertEquals((Object)"zero", (Object)HttpFields.valueParameters((String)((String)list.get(0)), null));
        Assert.assertEquals((Object)"one", (Object)HttpFields.valueParameters((String)((String)list.get(1)), null));
        Assert.assertEquals((Object)"1 + 1", (Object)HttpFields.valueParameters((String)((String)list.get(2)), null));
        Assert.assertEquals((Object)"three", (Object)HttpFields.valueParameters((String)((String)list.get(3)), null));
        Assert.assertEquals((Object)"four", (Object)HttpFields.valueParameters((String)((String)list.get(4)), null));
        Assert.assertEquals((Object)"I V", (Object)HttpFields.valueParameters((String)((String)list.get(5)), null));
        Assert.assertEquals((Object)"six", (Object)HttpFields.valueParameters((String)((String)list.get(6)), null));
        Assert.assertEquals((Object)"7", (Object)HttpFields.valueParameters((String)((String)list.get(7)), null));
    }

    @Test
    public void testGetQualityCSV() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("some", "value");
        fields.add("name", "zero;q=0.9,four;q=0.1");
        fields.put("other", "value");
        fields.add("name", "nothing;q=0");
        fields.add("name", "one;q=0.4");
        fields.add("name", "three;x=y;q=0.2;a=b,two;q=0.3");
        fields.add("name", "first;");
        List list = fields.getQualityCSV("name");
        Assert.assertEquals((Object)"first", (Object)HttpFields.valueParameters((String)((String)list.get(0)), null));
        Assert.assertEquals((Object)"zero", (Object)HttpFields.valueParameters((String)((String)list.get(1)), null));
        Assert.assertEquals((Object)"one", (Object)HttpFields.valueParameters((String)((String)list.get(2)), null));
        Assert.assertEquals((Object)"two", (Object)HttpFields.valueParameters((String)((String)list.get(3)), null));
        Assert.assertEquals((Object)"three", (Object)HttpFields.valueParameters((String)((String)list.get(4)), null));
        Assert.assertEquals((Object)"four", (Object)HttpFields.valueParameters((String)((String)list.get(5)), null));
    }

    @Test
    public void testGetQualityCSVHeader() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("some", "value");
        fields.add("Accept", "zero;q=0.9,four;q=0.1");
        fields.put("other", "value");
        fields.add("Accept", "nothing;q=0");
        fields.add("Accept", "one;q=0.4");
        fields.add("Accept", "three;x=y;q=0.2;a=b,two;q=0.3");
        fields.add("Accept", "first;");
        List list = fields.getQualityCSV(HttpHeader.ACCEPT);
        Assert.assertEquals((Object)"first", (Object)HttpFields.valueParameters((String)((String)list.get(0)), null));
        Assert.assertEquals((Object)"zero", (Object)HttpFields.valueParameters((String)((String)list.get(1)), null));
        Assert.assertEquals((Object)"one", (Object)HttpFields.valueParameters((String)((String)list.get(2)), null));
        Assert.assertEquals((Object)"two", (Object)HttpFields.valueParameters((String)((String)list.get(3)), null));
        Assert.assertEquals((Object)"three", (Object)HttpFields.valueParameters((String)((String)list.get(4)), null));
        Assert.assertEquals((Object)"four", (Object)HttpFields.valueParameters((String)((String)list.get(5)), null));
    }

    @Test
    public void testDateFields() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("D0", "Wed, 31 Dec 1969 23:59:59 GMT");
        fields.put("D1", "Fri, 31 Dec 1999 23:59:59 GMT");
        fields.put("D2", "Friday, 31-Dec-99 23:59:59 GMT");
        fields.put("D3", "Fri Dec 31 23:59:59 1999");
        fields.put("D4", "Mon Jan 1 2000 00:00:01");
        fields.put("D5", "Tue Feb 29 2000 12:00:00");
        long d1 = fields.getDateField("D1");
        long d0 = fields.getDateField("D0");
        long d2 = fields.getDateField("D2");
        long d3 = fields.getDateField("D3");
        long d4 = fields.getDateField("D4");
        long d5 = fields.getDateField("D5");
        Assert.assertTrue((d0 != -1L ? 1 : 0) != 0);
        Assert.assertTrue((d1 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((d2 > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)d1, (long)d2);
        Assert.assertEquals((long)d2, (long)d3);
        Assert.assertEquals((long)(d3 + 2000L), (long)d4);
        Assert.assertEquals((long)951825600000L, (long)d5);
        d1 = fields.getDateField("D1");
        d2 = fields.getDateField("D2");
        d3 = fields.getDateField("D3");
        d4 = fields.getDateField("D4");
        d5 = fields.getDateField("D5");
        Assert.assertTrue((d1 > 0L ? 1 : 0) != 0);
        Assert.assertTrue((d2 > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)d1, (long)d2);
        Assert.assertEquals((long)d2, (long)d3);
        Assert.assertEquals((long)(d3 + 2000L), (long)d4);
        Assert.assertEquals((long)951825600000L, (long)d5);
        fields.putDateField("D2", d1);
        Assert.assertEquals((Object)"Fri, 31 Dec 1999 23:59:59 GMT", (Object)fields.get("D2"));
    }

    @Test
    public void testNegDateFields() throws Exception {
        HttpFields fields = new HttpFields();
        fields.putDateField("Dzero", 0L);
        Assert.assertEquals((Object)"Thu, 01 Jan 1970 00:00:00 GMT", (Object)fields.get("Dzero"));
        fields.putDateField("Dminus", -1L);
        Assert.assertEquals((Object)"Wed, 31 Dec 1969 23:59:59 GMT", (Object)fields.get("Dminus"));
        fields.putDateField("Dminus", -1000L);
        Assert.assertEquals((Object)"Wed, 31 Dec 1969 23:59:59 GMT", (Object)fields.get("Dminus"));
        fields.putDateField("Dancient", Long.MIN_VALUE);
        Assert.assertEquals((Object)"Sun, 02 Dec 55 16:47:04 GMT", (Object)fields.get("Dancient"));
    }

    @Test
    public void testLongFields() throws Exception {
        HttpFields header = new HttpFields();
        header.put("I1", "42");
        header.put("I2", " 43 99");
        header.put("I3", "-44");
        header.put("I4", " - 45abc");
        header.put("N1", " - ");
        header.put("N2", "xx");
        long i1 = header.getLongField("I1");
        try {
            header.getLongField("I2");
            Assert.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assert.assertTrue((boolean)true);
        }
        long i3 = header.getLongField("I3");
        try {
            header.getLongField("I4");
            Assert.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            header.getLongField("N1");
            Assert.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            header.getLongField("N2");
            Assert.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertEquals((long)42L, (long)i1);
        Assert.assertEquals((long)-44L, (long)i3);
        header.putLongField("I5", 46L);
        header.putLongField("I6", -47L);
        Assert.assertEquals((Object)"46", (Object)header.get("I5"));
        Assert.assertEquals((Object)"-47", (Object)header.get("I6"));
    }

    @Test
    public void testContains() throws Exception {
        HttpFields header = new HttpFields();
        header.add("n0", "");
        header.add("n1", ",");
        header.add("n2", ",,");
        header.add("N3", "abc");
        header.add("N4", "def");
        header.add("n5", "abc,def,hig");
        header.add("N6", "abc");
        header.add("n6", "def");
        header.add("N6", "hig");
        header.add("n7", "abc ,  def;q=0.9  ,  hig");
        header.add("n8", "abc ,  def;q=0  ,  hig");
        header.add(HttpHeader.ACCEPT, "abc ,  def;q=0  ,  hig");
        for (int i = 0; i < 8; ++i) {
            Assert.assertTrue((boolean)header.containsKey("n" + i));
            Assert.assertTrue((boolean)header.containsKey("N" + i));
            Assert.assertFalse((String)("" + i), (boolean)header.contains("n" + i, "xyz"));
            Assert.assertEquals((String)("" + i), (Object)(i >= 4 ? 1 : 0), (Object)header.contains("n" + i, "def"));
        }
        Assert.assertTrue((boolean)header.contains(new HttpField("N5", "def")));
        Assert.assertTrue((boolean)header.contains(new HttpField("accept", "abc")));
        Assert.assertTrue((boolean)header.contains(HttpHeader.ACCEPT, "abc"));
        Assert.assertFalse((boolean)header.contains(new HttpField("N5", "xyz")));
        Assert.assertFalse((boolean)header.contains(new HttpField("N8", "def")));
        Assert.assertFalse((boolean)header.contains(HttpHeader.ACCEPT, "def"));
        Assert.assertFalse((boolean)header.contains(HttpHeader.AGE, "abc"));
        Assert.assertFalse((boolean)header.containsKey("n11"));
    }

    @Test
    public void testIteration() throws Exception {
        HttpFields header = new HttpFields();
        Iterator i = header.iterator();
        Assert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)false));
        header.put("name1", "valueA");
        header.put("name2", "valueB");
        header.add("name3", "valueC");
        i = header.iterator();
        Assert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name1"));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name2"));
        i.remove();
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name3"));
        Assert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)false));
        i = header.iterator();
        Assert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name1"));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name3"));
        Assert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)false));
        ListIterator l = header.listIterator();
        Assert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        l.add(new HttpField("name0", "value"));
        Assert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((HttpField)l.next()).getName(), (Matcher)Matchers.is((Object)"name1"));
        l.set(new HttpField("NAME1", "value"));
        Assert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((HttpField)l.previous()).getName(), (Matcher)Matchers.is((Object)"NAME1"));
        Assert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((HttpField)l.previous()).getName(), (Matcher)Matchers.is((Object)"name0"));
        Assert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((HttpField)l.next()).getName(), (Matcher)Matchers.is((Object)"name0"));
        Assert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((HttpField)l.next()).getName(), (Matcher)Matchers.is((Object)"NAME1"));
        l.add(new HttpField("name2", "value"));
        Assert.assertThat((Object)((HttpField)l.next()).getName(), (Matcher)Matchers.is((Object)"name3"));
        Assert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        l.add(new HttpField("name4", "value"));
        Assert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((HttpField)l.previous()).getName(), (Matcher)Matchers.is((Object)"name4"));
        i = header.iterator();
        Assert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name0"));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"NAME1"));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name2"));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name3"));
        Assert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name4"));
        Assert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)false));
    }
}

