/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.Map;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class UriTemplatePathSpecTest {
    private void assertDetectedVars(UriTemplatePathSpec spec, String ... expectedVars) {
        String prefix = String.format("Spec(\"%s\")", spec.getDeclaration());
        Assert.assertEquals((String)(prefix + ".variableCount"), (long)expectedVars.length, (long)spec.getVariableCount());
        Assert.assertEquals((String)(prefix + ".variable.length"), (long)expectedVars.length, (long)spec.getVariables().length);
        for (int i = 0; i < expectedVars.length; ++i) {
            Assert.assertEquals((String)String.format("%s.variable[%d]", prefix, i), (Object)expectedVars[i], (Object)spec.getVariables()[i]);
        }
    }

    private void assertMatches(PathSpec spec, String path) {
        String msg = String.format("Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        Assert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)true));
    }

    private void assertNotMatches(PathSpec spec, String path) {
        String msg = String.format("!Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        Assert.assertThat((String)msg, (Object)spec.matches(path), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDefaultPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)1L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.EXACT, (Object)spec.getGroup());
        Assert.assertEquals((String)"Spec.variableCount", (long)0L, (long)spec.getVariableCount());
        Assert.assertEquals((String)"Spec.variable.length", (long)0L, (long)spec.getVariables().length);
    }

    @Test
    public void testExactOnePathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/a", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/a$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)1L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.EXACT, (Object)spec.getGroup());
        this.assertMatches((PathSpec)spec, "/a");
        this.assertMatches((PathSpec)spec, "/a?type=other");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        this.assertNotMatches((PathSpec)spec, "/a/");
        Assert.assertEquals((String)"Spec.variableCount", (long)0L, (long)spec.getVariableCount());
        Assert.assertEquals((String)"Spec.variable.length", (long)0L, (long)spec.getVariables().length);
    }

    @Test
    public void testExactPathSpec_TestWebapp() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/deep.thought/");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/deep.thought/", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/deep\\.thought/$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)1L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.EXACT, (Object)spec.getGroup());
        this.assertMatches((PathSpec)spec, "/deep.thought/");
        this.assertNotMatches((PathSpec)spec, "/deep.thought");
        Assert.assertEquals((String)"Spec.variableCount", (long)0L, (long)spec.getVariableCount());
        Assert.assertEquals((String)"Spec.variable.length", (long)0L, (long)spec.getVariables().length);
    }

    @Test
    public void testExactTwoPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/b");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/a/b", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/a/b$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)2L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.EXACT, (Object)spec.getGroup());
        Assert.assertEquals((String)"Spec.variableCount", (long)0L, (long)spec.getVariableCount());
        Assert.assertEquals((String)"Spec.variable.length", (long)0L, (long)spec.getVariables().length);
        this.assertMatches((PathSpec)spec, "/a/b");
        this.assertNotMatches((PathSpec)spec, "/a/b/");
        this.assertNotMatches((PathSpec)spec, "/a/");
        this.assertNotMatches((PathSpec)spec, "/a/bb");
    }

    @Test
    public void testMiddleVarPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/{var}/c");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/a/{var}/c", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/a/([^/]+)/c$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)3L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup());
        this.assertDetectedVars(spec, "var");
        this.assertMatches((PathSpec)spec, "/a/b/c");
        this.assertMatches((PathSpec)spec, "/a/zz/c");
        this.assertMatches((PathSpec)spec, "/a/hello+world/c");
        this.assertNotMatches((PathSpec)spec, "/a/bc");
        this.assertNotMatches((PathSpec)spec, "/a/b/");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        Map mapped = spec.getPathParams("/a/b/c");
        Assert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertEquals((String)"Spec.pathParams[var]", (Object)"b", mapped.get("var"));
    }

    @Test
    public void testOneVarPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/{foo}");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/a/{foo}", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/a/([^/]+)$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)2L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.getGroup());
        this.assertDetectedVars(spec, "foo");
        this.assertMatches((PathSpec)spec, "/a/b");
        this.assertNotMatches((PathSpec)spec, "/a/");
        this.assertNotMatches((PathSpec)spec, "/a");
        Map mapped = spec.getPathParams("/a/b");
        Assert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertEquals((String)"Spec.pathParams[foo]", (Object)"b", mapped.get("foo"));
    }

    @Test
    public void testOneVarSuffixPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/{var}/b/c");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/{var}/b/c", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/([^/]+)/b/c$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)3L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.getGroup());
        this.assertDetectedVars(spec, "var");
        this.assertMatches((PathSpec)spec, "/a/b/c");
        this.assertMatches((PathSpec)spec, "/az/b/c");
        this.assertMatches((PathSpec)spec, "/hello+world/b/c");
        this.assertNotMatches((PathSpec)spec, "/a/bc");
        this.assertNotMatches((PathSpec)spec, "/a/b/");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        Map mapped = spec.getPathParams("/a/b/c");
        Assert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertEquals((String)"Spec.pathParams[var]", (Object)"a", mapped.get("var"));
    }

    @Test
    public void testTwoVarComplexInnerPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/{var1}/c/{var2}/e");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/a/{var1}/c/{var2}/e", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/a/([^/]+)/c/([^/]+)/e$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)5L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup());
        this.assertDetectedVars(spec, "var1", "var2");
        this.assertMatches((PathSpec)spec, "/a/b/c/d/e");
        this.assertNotMatches((PathSpec)spec, "/a/bc/d/e");
        this.assertNotMatches((PathSpec)spec, "/a/b/d/e");
        this.assertNotMatches((PathSpec)spec, "/a/b//d/e");
        Map mapped = spec.getPathParams("/a/b/c/d/e");
        Assert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertEquals((String)"Spec.pathParams[var1]", (Object)"b", mapped.get("var1"));
        Assert.assertEquals((String)"Spec.pathParams[var2]", (Object)"d", mapped.get("var2"));
    }

    @Test
    public void testTwoVarComplexOuterPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/{var1}/b/{var2}/{var3}");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/{var1}/b/{var2}/{var3}", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/([^/]+)/b/([^/]+)/([^/]+)$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)4L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup());
        this.assertDetectedVars(spec, "var1", "var2", "var3");
        this.assertMatches((PathSpec)spec, "/a/b/c/d");
        this.assertNotMatches((PathSpec)spec, "/a/bc/d/e");
        this.assertNotMatches((PathSpec)spec, "/a/c/d/e");
        this.assertNotMatches((PathSpec)spec, "/a//d/e");
        Map mapped = spec.getPathParams("/a/b/c/d");
        Assert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertEquals((String)"Spec.pathParams[var1]", (Object)"a", mapped.get("var1"));
        Assert.assertEquals((String)"Spec.pathParams[var2]", (Object)"c", mapped.get("var2"));
        Assert.assertEquals((String)"Spec.pathParams[var3]", (Object)"d", mapped.get("var3"));
    }

    @Test
    public void testTwoVarPrefixPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/a/{var1}/{var2}");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/a/{var1}/{var2}", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/a/([^/]+)/([^/]+)$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)3L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.getGroup());
        this.assertDetectedVars(spec, "var1", "var2");
        this.assertMatches((PathSpec)spec, "/a/b/c");
        this.assertNotMatches((PathSpec)spec, "/a/bc");
        this.assertNotMatches((PathSpec)spec, "/a/b/");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        Map mapped = spec.getPathParams("/a/b/c");
        Assert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertEquals((String)"Spec.pathParams[var1]", (Object)"b", mapped.get("var1"));
        Assert.assertEquals((String)"Spec.pathParams[var2]", (Object)"c", mapped.get("var2"));
    }

    @Test
    public void testVarOnlyPathSpec() {
        UriTemplatePathSpec spec = new UriTemplatePathSpec("/{var1}");
        Assert.assertEquals((String)"Spec.pathSpec", (Object)"/{var1}", (Object)spec.getDeclaration());
        Assert.assertEquals((String)"Spec.pattern", (Object)"^/([^/]+)$", (Object)spec.getPattern().pattern());
        Assert.assertEquals((String)"Spec.pathDepth", (long)1L, (long)spec.getPathDepth());
        Assert.assertEquals((String)"Spec.group", (Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.getGroup());
        this.assertDetectedVars(spec, "var1");
        this.assertMatches((PathSpec)spec, "/a");
        this.assertNotMatches((PathSpec)spec, "/");
        this.assertNotMatches((PathSpec)spec, "/a/b");
        this.assertNotMatches((PathSpec)spec, "/a/b/c");
        Map mapped = spec.getPathParams("/a");
        Assert.assertThat((String)"Spec.pathParams", (Object)mapped, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Spec.pathParams.size", (Object)mapped.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertEquals((String)"Spec.pathParams[var1]", (Object)"a", mapped.get("var1"));
    }
}

