/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.docs.programming;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

public class ComponentDocs {
    public void start() throws Exception {
        class Root
        extends ContainerLifeCycle {
            private final 1Monitor monitor;

            public Root() {
                class Monitor
                extends AbstractLifeCycle {
                    Monitor() {
                    }
                }
                this.monitor = new Monitor();
                this.addManaged((LifeCycle)this.monitor);
            }
        }
        Root root = new Root();
        class Service
        extends ContainerLifeCycle {
            private ScheduledExecutorService scheduler;

            Service() {
            }

            protected void doStart() throws Exception {
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
                this.addBean(this.scheduler);
                super.doStart();
            }

            protected void doStop() throws Exception {
                super.doStop();
                this.removeBean(this.scheduler);
                this.scheduler.shutdown();
            }
        }
        Service service = new Service();
        root.addBean((Object)service);
        root.start();
    }

    public void restart() throws Exception {
        class Root
        extends ContainerLifeCycle {
            Root() {
            }
        }
        Root root = new Root();
        class Service
        extends ContainerLifeCycle {
            private ScheduledExecutorService scheduler;

            Service() {
            }

            protected void doStart() throws Exception {
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
                this.addBean(this.scheduler);
                super.doStart();
            }

            protected void doStop() throws Exception {
                super.doStop();
                this.removeBean(this.scheduler);
                this.scheduler.shutdown();
            }
        }
        Service service = new Service();
        root.addBean((Object)service);
        root.start();
        service.stop();
        service.start();
    }

    public void getBeans() throws Exception {
        class Root
        extends ContainerLifeCycle {
            Root() {
            }
        }
        Root root = new Root();
        class Service
        extends ContainerLifeCycle {
            private ScheduledExecutorService scheduler;

            Service() {
            }

            protected void doStart() throws Exception {
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
                this.addBean(this.scheduler);
                super.doStart();
            }

            protected void doStop() throws Exception {
                super.doStop();
                this.removeBean(this.scheduler);
                this.scheduler.shutdown();
            }
        }
        Service service = new Service();
        root.addBean((Object)service);
        root.start();
        Collection children = root.getBeans();
        Collection schedulers = root.getContainedBeans(ScheduledExecutorService.class);
    }

    public void lifecycleListener() {
        Server server = new Server();
        server.addEventListener((EventListener)new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle lifeCycle) {
                System.getLogger("server").log(System.Logger.Level.INFO, "Server {0} has been started", lifeCycle);
            }

            public void lifeCycleFailure(LifeCycle lifeCycle, Throwable failure) {
                System.getLogger("server").log(System.Logger.Level.INFO, "Server {0} failed to start", lifeCycle, failure);
            }

            public void lifeCycleStopped(LifeCycle lifeCycle) {
                System.getLogger("server").log(System.Logger.Level.INFO, "Server {0} has been stopped", lifeCycle);
            }
        });
    }

    public void containerListener() {
        Server server = new Server();
        server.addEventListener((EventListener)new Container.Listener(){

            public void beanAdded(Container parent, Object child) {
                System.getLogger("server").log(System.Logger.Level.INFO, "Added bean {1} to {0}", parent, child);
            }

            public void beanRemoved(Container parent, Object child) {
                System.getLogger("server").log(System.Logger.Level.INFO, "Removed bean {1} from {0}", parent, child);
            }
        });
    }

    public void containerSiblings() {
        class Parent
        extends ContainerLifeCycle {
            Parent() {
            }
        }
        Parent parent = new Parent();
        class OlderChild
        extends Child
        implements Container.Listener {
            private Set<Object> siblings;

            OlderChild() {
                class Child {
                    Child() {
                    }
                }
                this.siblings = new HashSet<Object>();
            }

            public void beanAdded(Container parent, Object child) {
                this.siblings.add(child);
            }

            public void beanRemoved(Container parent, Object child) {
                this.siblings.remove(child);
            }
        }
        OlderChild older = new OlderChild();
        parent.addBean(older);
        Child younger = new Child();
        parent.addBean(younger);
    }
}

