/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.continuation;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;

public class ContinuationFilter
implements Filter {
    private boolean _faux;
    private ServletContext _context;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._context = filterConfig.getServletContext();
        this._faux = !"org.eclipse.jetty.servlet".equals(filterConfig.getClass().getPackage().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this._faux) {
            FauxContinuation fc = new FauxContinuation();
            request.setAttribute("org.eclipse.jetty.continuation", (Object)fc);
            boolean complete = false;
            while (!complete) {
                try {
                    chain.doFilter(request, response);
                }
                catch (IOException e) {
                    this._context.log("OpenServletFilter caught ", (Throwable)e);
                }
                catch (ServletException e) {
                    this._context.log("OpenServletFilter caught ", (Throwable)e);
                }
                finally {
                    complete = fc.handleSuspension();
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private class FauxContinuation
    implements Continuation {
        private static final int __HANDLING = 1;
        private static final int __SUSPENDING = 2;
        private static final int __RESUMING = 3;
        private static final int __COMPLETING = 4;
        private static final int __SUSPENDED = 5;
        private static final int __UNSUSPENDING = 6;
        private static final int __COMPLETE = 7;
        private int _state = 1;
        private boolean _initial = true;
        private boolean _resumed = false;
        private boolean _timeout = false;
        private boolean _keepWrappers = false;
        private long _timeoutMs = 30000L;
        private ArrayList<ContinuationListener> _listeners;

        private FauxContinuation() {
        }

        public void keepWrappers() {
            this._keepWrappers = true;
        }

        public boolean wrappersKept() {
            return this._keepWrappers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInitial() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                return this._initial;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isResumed() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                return this._resumed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSuspended() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                switch (this._state) {
                    case 1: {
                        return false;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isExpired() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                return this._timeout;
            }
        }

        public void setTimeout(long timeoutMs) {
            this._timeoutMs = timeoutMs;
        }

        public void suspend() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                switch (this._state) {
                    case 1: {
                        this._timeout = false;
                        this._resumed = false;
                        this._state = 2;
                        return;
                    }
                    case 2: 
                    case 3: {
                        return;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new IllegalStateException(this.getStatusString());
                    }
                }
                throw new IllegalStateException("" + this._state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                switch (this._state) {
                    case 1: {
                        this._resumed = true;
                        return;
                    }
                    case 2: {
                        this._resumed = true;
                        this._state = 3;
                        return;
                    }
                    case 3: 
                    case 4: {
                        return;
                    }
                    case 5: {
                        this.fauxResume();
                        this._resumed = true;
                        this._state = 6;
                        break;
                    }
                    case 6: {
                        this._resumed = true;
                        return;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusString());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                switch (this._state) {
                    case 1: {
                        throw new IllegalStateException(this.getStatusString());
                    }
                    case 2: {
                        this._state = 4;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        return;
                    }
                    case 5: {
                        this._state = 4;
                        this.fauxResume();
                        break;
                    }
                    case 6: {
                        return;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusString());
                    }
                }
            }
        }

        void handling() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                this._keepWrappers = false;
                switch (this._state) {
                    case 1: {
                        throw new IllegalStateException(this.getStatusString());
                    }
                    case 2: 
                    case 3: {
                        throw new IllegalStateException(this.getStatusString());
                    }
                    case 4: {
                        return;
                    }
                    case 5: {
                        this.fauxResume();
                    }
                    case 6: {
                        this._state = 1;
                        return;
                    }
                }
                throw new IllegalStateException("" + this._state);
            }
        }

        public boolean handleSuspension() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                switch (this._state) {
                    case 1: {
                        this._state = 7;
                        return true;
                    }
                    case 2: {
                        this._initial = false;
                        this._state = 5;
                        this.fauxSuspend();
                        if (this._state == 5 || this._state == 4) {
                            return true;
                        }
                        this._initial = false;
                        this._state = 1;
                        return false;
                    }
                    case 3: {
                        this._initial = false;
                        this._state = 1;
                        return false;
                    }
                    case 4: {
                        this._initial = false;
                        this._state = 7;
                        return true;
                    }
                }
                throw new IllegalStateException(this.getStatusString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void expire() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                switch (this._state) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        this._timeout = true;
                        this._state = 3;
                        this.fauxResume();
                        return;
                    }
                    case 3: {
                        return;
                    }
                    case 4: {
                        return;
                    }
                    case 5: {
                        this._timeout = true;
                        this._state = 6;
                        break;
                    }
                    case 6: {
                        this._timeout = true;
                        return;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusString());
                    }
                }
            }
        }

        private void fauxSuspend() {
            long expire_at = System.currentTimeMillis() + this._timeoutMs;
            long wait = this._timeoutMs;
            while (this._timeoutMs > 0L && wait > 0L) {
                try {
                    this.wait(wait);
                }
                catch (InterruptedException e) {
                    ContinuationFilter.this._context.log("OpenServletFilter caught ", (Throwable)e);
                }
                wait = expire_at - System.currentTimeMillis();
            }
            if (this._timeoutMs > 0L && wait <= 0L) {
                this.expire();
            }
        }

        private void fauxResume() {
            this._timeoutMs = 0L;
            this.notifyAll();
        }

        public String toString() {
            return this.getStatusString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getStatusString() {
            FauxContinuation fauxContinuation = this;
            synchronized (fauxContinuation) {
                return (this._state == 1 ? "HANDLING" : (this._state == 2 ? "SUSPENDING" : (this._state == 5 ? "SUSPENDED" : (this._state == 3 ? "RESUMING" : (this._state == 6 ? "UNSUSPENDING" : (this._state == 4 ? "COMPLETING" : "???" + this._state)))))) + (this._initial ? ",initial" : "") + (this._resumed ? ",resumed" : "") + (this._timeout ? ",timeout" : "");
            }
        }

        public void addContinuationListener(ContinuationListener listener) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            this._listeners.add(listener);
        }
    }
}

