/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.ant.AntWebAppContext;
import org.eclipse.jetty.ant.types.Connector;
import org.eclipse.jetty.ant.types.ContextHandlers;
import org.eclipse.jetty.ant.utils.ServerProxy;
import org.eclipse.jetty.ant.utils.TaskLog;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.xml.sax.SAXException;

public class ServerProxyImpl
implements ServerProxy {
    private Server server;
    private File tempDirectory;
    private ContextHandlerCollection contexts;
    private File jettyXml;
    private List<Connector> connectors;
    private RequestLog requestLog;
    private List<LoginService> loginServices;
    private List<AntWebAppContext> webApplications = new ArrayList<AntWebAppContext>();
    private ContextHandlers contextHandlers;
    private int scanIntervalSecs;
    private int stopPort;
    private String stopKey;
    private boolean daemon;
    private boolean configured = false;

    public ServerProxyImpl() {
        this.server = new Server();
        this.server.setStopAtShutdown(true);
    }

    @Override
    public void addWebApplication(AntWebAppContext webApp) {
        this.webApplications.add(webApp);
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
    }

    public File getJettyXml() {
        return this.jettyXml;
    }

    public void setJettyXml(File jettyXml) {
        this.jettyXml = jettyXml;
    }

    public List<Connector> getConnectors() {
        return this.connectors;
    }

    public void setConnectors(List<Connector> connectors) {
        this.connectors = connectors;
    }

    public RequestLog getRequestLog() {
        return this.requestLog;
    }

    public void setRequestLog(RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    public List<LoginService> getLoginServices() {
        return this.loginServices;
    }

    public void setLoginServices(List<LoginService> loginServices) {
        this.loginServices = loginServices;
    }

    public List<AntWebAppContext> getWebApplications() {
        return this.webApplications;
    }

    public void setWebApplications(List<AntWebAppContext> webApplications) {
        this.webApplications = webApplications;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    @Override
    public void start() {
        try {
            this.configure();
            this.configureWebApps();
            this.server.start();
            System.setProperty("jetty.ant.server.port", "" + ((ServerConnector)this.server.getConnectors()[0]).getLocalPort());
            String host = ((ServerConnector)this.server.getConnectors()[0]).getHost();
            if (host == null) {
                System.setProperty("jetty.ant.server.host", "localhost");
            } else {
                System.setProperty("jetty.ant.server.host", host);
            }
            this.startScanners();
            TaskLog.log("Jetty AntTask Started");
            if (!this.daemon) {
                this.server.join();
            }
        }
        catch (InterruptedException e) {
            new RuntimeException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            new RuntimeException(e);
        }
    }

    @Override
    public Object getProxiedObject() {
        return this.server;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public ContextHandlers getContextHandlers() {
        return this.contextHandlers;
    }

    public void setContextHandlers(ContextHandlers contextHandlers) {
        this.contextHandlers = contextHandlers;
    }

    public int getScanIntervalSecs() {
        return this.scanIntervalSecs;
    }

    public void setScanIntervalSecs(int scanIntervalSecs) {
        this.scanIntervalSecs = scanIntervalSecs;
    }

    private void configure() {
        if (this.configured) {
            return;
        }
        this.configured = true;
        if (this.stopPort > 0 && this.stopKey != null) {
            ShutdownMonitor monitor = ShutdownMonitor.getInstance();
            monitor.setPort(this.stopPort);
            monitor.setKey(this.stopKey);
            monitor.setExitVm(false);
        }
        if (this.tempDirectory != null && !this.tempDirectory.exists()) {
            this.tempDirectory.mkdirs();
        }
        this.applyJettyXml();
        if (this.connectors != null) {
            for (Connector c : this.connectors) {
                ServerConnector jc = new ServerConnector(this.server);
                jc.setPort(c.getPort());
                jc.setIdleTimeout((long)c.getMaxIdleTime());
                this.server.addConnector((org.eclipse.jetty.server.Connector)jc);
            }
        }
        if (this.loginServices != null) {
            for (LoginService ls : this.loginServices) {
                this.server.addBean((Object)ls);
            }
        }
        Resource.setDefaultUseCaches((boolean)false);
        this.configureHandlers();
    }

    private void configureHandlers() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        if (this.requestLog != null) {
            requestLogHandler.setRequestLog(this.requestLog);
        }
        this.contexts = (ContextHandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this.contexts == null) {
            this.contexts = new ContextHandlerCollection();
            HandlerCollection handlers = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
            if (handlers == null) {
                handlers = new HandlerCollection();
                this.server.setHandler((Handler)handlers);
                handlers.setHandlers(new Handler[]{this.contexts, new DefaultHandler(), requestLogHandler});
            } else {
                handlers.addHandler((Handler)this.contexts);
            }
        }
        if (this.contextHandlers != null && this.contextHandlers.getContextHandlers() != null) {
            for (ContextHandler c : this.contextHandlers.getContextHandlers()) {
                this.contexts.addHandler((Handler)c);
            }
        }
    }

    private void applyJettyXml() {
        if (this.jettyXml != null && this.jettyXml.exists()) {
            TaskLog.log("Configuring jetty from xml configuration file = " + this.jettyXml.getAbsolutePath());
            try {
                XmlConfiguration configuration = new XmlConfiguration(Resource.toURL((File)this.jettyXml));
                configuration.configure((Object)this.server);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void startScanners() throws Exception {
        for (AntWebAppContext awc : this.webApplications) {
            if (this.scanIntervalSecs <= 0) {
                return;
            }
            List<File> scanList = awc.getScanFiles();
            TaskLog.log("Web application '" + (Object)((Object)awc) + "': starting scanner at interval of " + this.scanIntervalSecs + " seconds.");
            WebAppScannerListener changeListener = new WebAppScannerListener(awc);
            Scanner scanner = new Scanner();
            scanner.setScanInterval(this.scanIntervalSecs);
            scanner.addListener((Scanner.Listener)changeListener);
            scanner.setScanDirs(scanList);
            scanner.setReportExistingFilesOnStartup(false);
            scanner.start();
        }
    }

    private void configureWebApps() {
        for (AntWebAppContext awc : this.webApplications) {
            awc.setAttribute("org.eclipse.jetty.webapp.basetempdir", this.tempDirectory);
            if (this.contexts == null) continue;
            this.contexts.addHandler((Handler)awc);
        }
    }

    public static class WebAppScannerListener
    implements Scanner.BulkListener {
        AntWebAppContext awc;

        public WebAppScannerListener(AntWebAppContext awc) {
            this.awc = awc;
        }

        public void filesChanged(List<String> changedFileNames) {
            boolean isScanned = false;
            try {
                Iterator<String> itor = changedFileNames.iterator();
                while (!isScanned && itor.hasNext()) {
                    isScanned = this.awc.isScanned(Resource.newResource((String)itor.next()).getFile());
                }
                if (isScanned) {
                    this.awc.stop();
                    this.awc.start();
                }
            }
            catch (Exception e) {
                TaskLog.log(e.getMessage());
            }
        }
    }
}

