/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ant.AntWebInfConfiguration;
import org.eclipse.jetty.ant.types.Attribute;
import org.eclipse.jetty.ant.types.Attributes;
import org.eclipse.jetty.ant.types.FileMatchingConfiguration;
import org.eclipse.jetty.ant.utils.TaskLog;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlConfiguration;

public class AntWebAppContext
extends WebAppContext {
    public final AntWebInfConfiguration antWebInfConfiguration = new AntWebInfConfiguration();
    public final WebXmlConfiguration webXmlConfiguration = new WebXmlConfiguration();
    public final MetaInfConfiguration metaInfConfiguration = new MetaInfConfiguration();
    public final FragmentConfiguration fragmentConfiguration = new FragmentConfiguration();
    public final EnvConfiguration envConfiguration = new EnvConfiguration();
    public final PlusConfiguration plusConfiguration = new PlusConfiguration();
    public final AnnotationConfiguration annotationConfiguration = new AnnotationConfiguration();
    public final JettyWebXmlConfiguration jettyWebXmlConfiguration = new JettyWebXmlConfiguration();
    public final TagLibConfiguration tagLibConfiguration = new TagLibConfiguration();
    public final Configuration[] DEFAULT_CONFIGURATIONS = new Configuration[]{this.antWebInfConfiguration, this.webXmlConfiguration, this.metaInfConfiguration, this.fragmentConfiguration, this.envConfiguration, this.plusConfiguration, this.annotationConfiguration, this.jettyWebXmlConfiguration, this.tagLibConfiguration};
    public static final String DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN = ".*/.*jsp-api-[^/]*\\.jar$|.*/.*jsp-[^/]*\\.jar$|.*/.*taglibs[^/]*\\.jar$|.*/.*jstl[^/]*\\.jar$|.*/.*jsf-impl-[^/]*\\.jar$|.*/.*javax.faces-[^/]*\\.jar$|.*/.*myfaces-impl-[^/]*\\.jar$";
    private File jettyEnvXml;
    private List libraries = new ArrayList();
    private List classes = new ArrayList();
    private File contextXml;
    private FileSet scanTargets;
    private Attributes attributes;
    private Project project;
    private List<File> scanFiles;
    private FileMatchingConfiguration extraScanTargetsConfiguration;
    private FileMatchingConfiguration librariesConfiguration;

    public static void dump(ClassLoader loader) {
        while (loader != null) {
            URL[] urls;
            System.err.println(loader);
            if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()) != null) {
                for (URL u : urls) {
                    System.err.println("\t" + u + "\n");
                }
            }
            loader = loader.getParent();
        }
    }

    public AntWebAppContext(Project project) throws Exception {
        this.project = project;
        this.setConfigurations(this.DEFAULT_CONFIGURATIONS);
        this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN);
        this.setParentLoaderPriority(true);
    }

    public void addAttributes(Attributes atts) {
        if (this.attributes != null) {
            throw new BuildException("Only one <attributes> tag is allowed!");
        }
        this.attributes = atts;
    }

    public void addLib(FileSet lib) {
        this.libraries.add(lib);
    }

    public void addClasses(FileSet classes) {
        this.classes.add(classes);
    }

    protected ServletHandler newServletHandler() {
        return new AntServletHandler();
    }

    public void setJettyEnvXml(File jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
        TaskLog.log("jetty-env.xml file: = " + (jettyEnvXml == null ? null : jettyEnvXml.getAbsolutePath()));
    }

    public File getJettyEnvXml() {
        return this.jettyEnvXml;
    }

    public List getLibraries() {
        return this.librariesConfiguration.getBaseDirectories();
    }

    public void addScanTargets(FileSet scanTargets) {
        if (this.scanTargets != null) {
            throw new BuildException("Only one <scanTargets> tag is allowed!");
        }
        this.scanTargets = scanTargets;
    }

    public List getScanTargetFiles() {
        if (this.scanTargets == null) {
            return null;
        }
        FileMatchingConfiguration configuration = new FileMatchingConfiguration();
        configuration.addDirectoryScanner(this.scanTargets.getDirectoryScanner(this.project));
        return configuration.getBaseDirectories();
    }

    public List<File> getScanFiles() {
        if (this.scanFiles == null) {
            this.scanFiles = this.initScanFiles();
        }
        return this.scanFiles;
    }

    public boolean isScanned(File file) {
        List<File> files = this.getScanFiles();
        if (files == null || files.isEmpty()) {
            return false;
        }
        return files.contains(file);
    }

    public List<File> initScanFiles() {
        List scanFiles;
        List<File> cpFiles;
        Resource r;
        ArrayList<File> scanList = new ArrayList<File>();
        if (this.getDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.getDescriptor());
                scanList.add(r.getFile());
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (this.getJettyEnvXml() != null) {
            try {
                r = Resource.newResource((File)this.getJettyEnvXml());
                scanList.add(r.getFile());
            }
            catch (IOException e) {
                throw new BuildException("Problem configuring scanner for jetty-env.xml", (Throwable)e);
            }
        }
        if (this.getDefaultsDescriptor() != null) {
            try {
                if (!"org/eclipse/jetty/webapp/webdefault.xml".equals(this.getDefaultsDescriptor())) {
                    r = Resource.newResource((String)this.getDefaultsDescriptor());
                    scanList.add(r.getFile());
                }
            }
            catch (IOException e) {
                throw new BuildException("Problem configuring scanner for webdefaults.xml", (Throwable)e);
            }
        }
        if (this.getOverrideDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.getOverrideDescriptor());
                scanList.add(r.getFile());
            }
            catch (IOException e) {
                throw new BuildException("Problem configuring scanner for webdefaults.xml", (Throwable)e);
            }
        }
        if ((cpFiles = this.getClassPathFiles()) != null) {
            scanList.addAll(cpFiles);
        }
        if ((scanFiles = this.getScanTargetFiles()) != null) {
            scanList.addAll(scanFiles);
        }
        return scanList;
    }

    public void setWar(String path) {
        super.setWar(path);
        try {
            Resource war = Resource.newResource((String)path);
            if (war.exists() && war.isDirectory() && this.getDescriptor() == null) {
                Resource webXml = war.addPath("WEB-INF/web.xml");
                this.setDescriptor(webXml.toString());
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void doStart() {
        try {
            TaskLog.logWithTimestamp("Starting web application " + this.getDescriptor());
            if (this.jettyEnvXml != null && this.jettyEnvXml.exists()) {
                this.envConfiguration.setJettyEnvXml(Resource.toURL((File)this.jettyEnvXml));
            }
            this.setClassLoader((ClassLoader)new WebAppClassLoader(((Object)((Object)this)).getClass().getClassLoader(), (WebAppClassLoader.Context)this));
            if (this.attributes != null && this.attributes.getAttributes() != null) {
                for (Attribute a : this.attributes.getAttributes()) {
                    this.setAttribute(a.getName(), a.getValue());
                }
            }
            if (this.contextXml != null) {
                XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)this.contextXml));
                TaskLog.log("Applying context xml file " + this.contextXml);
                xmlConfiguration.configure((Object)this);
            }
            super.doStart();
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    public void doStop() {
        try {
            this.scanFiles = null;
            TaskLog.logWithTimestamp("Stopping web application " + (Object)((Object)this));
            Thread.currentThread();
            Thread.sleep(500L);
            super.doStop();
        }
        catch (InterruptedException e) {
            TaskLog.log(e.toString());
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    public List<File> getClassPathFiles() {
        ArrayList<File> classPathFiles = new ArrayList<File>();
        for (FileSet clazz : this.classes) {
            classPathFiles.add(clazz.getDirectoryScanner(this.project).getBasedir());
        }
        for (FileSet library : this.libraries) {
            String[] includedFiles = library.getDirectoryScanner(this.project).getIncludedFiles();
            File baseDir = library.getDirectoryScanner(this.project).getBasedir();
            for (int i = 0; i < includedFiles.length; ++i) {
                classPathFiles.add(new File(baseDir, includedFiles[i]));
            }
        }
        return classPathFiles;
    }

    public FileMatchingConfiguration getLibrariesConfiguration() {
        FileMatchingConfiguration config = new FileMatchingConfiguration();
        for (FileSet clazz : this.classes) {
            config.addDirectoryScanner(clazz.getDirectoryScanner(this.project));
        }
        for (FileSet library : this.libraries) {
            config.addDirectoryScanner(library.getDirectoryScanner(this.project));
        }
        return config;
    }

    public File getContextXml() {
        return this.contextXml;
    }

    public void setContextXml(File contextXml) {
        this.contextXml = contextXml;
    }

    public static class AntServletHandler
    extends ServletHandler {
        public ServletHolder newServletHolder(Holder.Source source) {
            return new AntServletHolder();
        }
    }

    public static class AntServletHolder
    extends ServletHolder {
        public AntServletHolder() {
        }

        public AntServletHolder(Class<? extends Servlet> servlet) {
            super(servlet);
        }

        public AntServletHolder(Servlet servlet) {
            super(servlet);
        }

        public AntServletHolder(String name, Class<? extends Servlet> servlet) {
            super(name, servlet);
        }

        public AntServletHolder(String name, Servlet servlet) {
            super(name, servlet);
        }

        protected void initJspServlet() throws Exception {
            String classpath;
            ContextHandler ch = ContextHandler.getContextHandler((ServletContext)this.getServletHandler().getServletContext());
            ch.setAttribute("org.apache.catalina.jsp_classpath", (Object)ch.getClassPath());
            String sysClassPath = this.getSystemClassPath(ch.getClassLoader().getParent());
            this.setInitParameter("com.sun.appserv.jsp.classpath", sysClassPath);
            if ("?".equals(this.getInitParameter("classpath")) && (classpath = ch.getClassPath()) != null) {
                this.setInitParameter("classpath", classpath);
            }
        }

        protected String getSystemClassPath(ClassLoader loader) throws Exception {
            StringBuilder classpath = new StringBuilder();
            while (loader != null) {
                if (loader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)loader).getURLs();
                    if (urls != null) {
                        for (int i = 0; i < urls.length; ++i) {
                            Resource resource = Resource.newResource((URL)urls[i]);
                            File file = resource.getFile();
                            if (file == null || !file.exists()) continue;
                            if (classpath.length() > 0) {
                                classpath.append(File.pathSeparatorChar);
                            }
                            classpath.append(file.getAbsolutePath());
                        }
                    }
                } else if (loader instanceof AntClassLoader) {
                    classpath.append(((AntClassLoader)loader).getClasspath());
                }
                loader = loader.getParent();
            }
            return classpath.toString();
        }
    }
}

