/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.tools.ant.AntClassLoader;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ant.AntWebInfConfiguration;
import org.eclipse.jetty.ant.AntWebXmlConfiguration;
import org.eclipse.jetty.ant.types.Attribute;
import org.eclipse.jetty.ant.types.FileMatchingConfiguration;
import org.eclipse.jetty.ant.utils.TaskLog;
import org.eclipse.jetty.ant.utils.WebApplicationProxy;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebApplicationProxyImpl
implements WebApplicationProxy {
    static File baseTempDirectory = new File(".");
    private String name;
    private File warFile;
    private String contextPath;
    private File webXmlFile;
    private File jettyEnvXml;
    private List classPathFiles;
    private WebAppContext webAppContext;
    private FileMatchingConfiguration extraScanTargetsConfiguration;
    private List contextHandlers;
    private List attributes;
    Configuration[] configurations;
    private FileMatchingConfiguration librariesConfiguration;
    private File webDefaultXmlFile;

    public static void setBaseTempDirectory(File tempDirectory) {
        baseTempDirectory = tempDirectory;
    }

    public WebApplicationProxyImpl(String name) throws Exception {
        this.name = name;
        TaskLog.log("\nConfiguring Jetty for web application: " + name);
        this.configurations = new Configuration[]{new AntWebInfConfiguration(), new AntWebXmlConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration(), new PlusConfiguration(), new AnnotationConfiguration(), new JettyWebXmlConfiguration(), new TagLibConfiguration()};
    }

    public List getClassPathFiles() {
        return this.classPathFiles;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getName() {
        return this.name;
    }

    public File getSourceDirectory() {
        return this.warFile;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public void setSourceDirectory(File warFile) {
        this.warFile = warFile;
        TaskLog.log("Webapp source directory = " + warFile);
    }

    public void setContextPath(String contextPath) {
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        this.contextPath = contextPath;
        TaskLog.log("Context path = " + contextPath);
    }

    public void setWebXml(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void setJettyEnvXml(File jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
        if (this.jettyEnvXml != null) {
            TaskLog.log("jetty-env.xml file: = " + jettyEnvXml.getAbsolutePath());
        }
    }

    public void setClassPathFiles(List classPathFiles) {
        this.classPathFiles = classPathFiles;
        TaskLog.log("Classpath = " + classPathFiles);
    }

    public boolean isFileScanned(String pathToFile) {
        return this.librariesConfiguration.isIncluded(pathToFile) || this.extraScanTargetsConfiguration.isIncluded(pathToFile);
    }

    public void setLibrariesConfiguration(FileMatchingConfiguration classesConfiguration) {
        TaskLog.log("Default scanned paths = " + classesConfiguration.getBaseDirectories());
        this.librariesConfiguration = classesConfiguration;
    }

    public List getLibraries() {
        return this.librariesConfiguration.getBaseDirectories();
    }

    public void setExtraScanTargetsConfiguration(FileMatchingConfiguration extraScanTargetsConfiguration) {
        this.extraScanTargetsConfiguration = extraScanTargetsConfiguration;
        TaskLog.log("Extra scan targets = " + extraScanTargetsConfiguration.getBaseDirectories());
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public List getExtraScanTargets() {
        return this.extraScanTargetsConfiguration.getBaseDirectories();
    }

    public List getContextHandlers() {
        return this.contextHandlers;
    }

    public void setContextHandlers(List contextHandlers) {
        this.contextHandlers = contextHandlers;
    }

    @Override
    public Object getProxiedObject() {
        return this.webAppContext;
    }

    @Override
    public void start() {
        try {
            TaskLog.logWithTimestamp("Starting web application " + this.name + " ...\n");
            this.webAppContext.start();
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    @Override
    public void stop() {
        try {
            TaskLog.logWithTimestamp("Stopping web application " + this.name + " ...");
            Thread.currentThread();
            Thread.sleep(500L);
            this.webAppContext.stop();
        }
        catch (InterruptedException e) {
            TaskLog.log(e.toString());
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    @Override
    public void createApplicationContext(ContextHandlerCollection contexts) {
        this.webAppContext = new AntWebAppContext((HandlerContainer)contexts, this.warFile.getAbsolutePath(), this.contextPath);
        this.webAppContext.setDisplayName(this.name);
        this.configurePaths();
        if (!this.attributes.isEmpty()) {
            for (Attribute attr : this.attributes) {
                this.webAppContext.setAttribute(attr.getName(), (Object)attr.getValue());
            }
        }
        this.configureHandlers(contexts);
        this.applyConfiguration();
    }

    private void configureHandlers(ContextHandlerCollection contexts) {
        for (ContextHandler contextHandler : this.contextHandlers) {
            contexts.addHandler((Handler)contextHandler);
        }
    }

    private void configurePaths() {
        File tempDir = new File(baseTempDirectory, this.contextPath);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        this.webAppContext.setTempDirectory(tempDir);
        tempDir.deleteOnExit();
        TaskLog.log("Temp directory = " + tempDir.getAbsolutePath());
        if (this.warFile.isFile()) {
            this.warFile = new File(tempDir, "webapp");
            this.webXmlFile = new File(new File(this.warFile, "WEB-INF"), "web.xml");
        }
    }

    void applyConfiguration() {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (this.configurations[i] instanceof EnvConfiguration) {
                try {
                    if (this.jettyEnvXml == null || !this.jettyEnvXml.exists()) continue;
                    ((EnvConfiguration)this.configurations[i]).setJettyEnvXml(Resource.toURL((File)this.jettyEnvXml));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(this.configurations[i] instanceof AntWebXmlConfiguration)) continue;
            ((AntWebXmlConfiguration)this.configurations[i]).setClassPathFiles(this.classPathFiles);
            ((AntWebXmlConfiguration)this.configurations[i]).setWebAppBaseDir(this.warFile);
            ((AntWebXmlConfiguration)this.configurations[i]).setWebXmlFile(this.webXmlFile);
            ((AntWebXmlConfiguration)this.configurations[i]).setWebDefaultXmlFile(this.webDefaultXmlFile);
        }
        try {
            WebAppClassLoader loader = new WebAppClassLoader(this.getClass().getClassLoader(), (WebAppClassLoader.Context)this.webAppContext);
            this.webAppContext.setParentLoaderPriority(true);
            this.webAppContext.setClassLoader((ClassLoader)loader);
            if (this.webDefaultXmlFile != null) {
                this.webAppContext.setDefaultsDescriptor(this.webDefaultXmlFile.getCanonicalPath());
            }
        }
        catch (IOException e) {
            TaskLog.log(e.toString());
        }
        this.webAppContext.setConfigurations(this.configurations);
    }

    public File getWebDefaultXmlFile() {
        return this.webDefaultXmlFile;
    }

    public void setWebDefaultXmlFile(File webDefaultXmlfile) {
        this.webDefaultXmlFile = webDefaultXmlfile;
    }

    public static class AntWebAppContext
    extends WebAppContext {
        public AntWebAppContext() {
        }

        public AntWebAppContext(HandlerContainer parent, String webApp, String contextPath) {
            super(parent, webApp, contextPath);
        }

        public AntWebAppContext(SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
            super(sessionHandler, securityHandler, servletHandler, errorHandler);
        }

        public AntWebAppContext(String webApp, String contextPath) {
            super(webApp, contextPath);
        }

        protected ServletHandler newServletHandler() {
            return new AntServletHandler();
        }
    }

    public static class AntServletHandler
    extends ServletHandler {
        public ServletHolder newServletHolder(Holder.Source source) {
            return new AntServletHolder();
        }
    }

    public static class AntServletHolder
    extends ServletHolder {
        public AntServletHolder() {
        }

        public AntServletHolder(Class<? extends Servlet> servlet) {
            super(servlet);
        }

        public AntServletHolder(Servlet servlet) {
            super(servlet);
        }

        public AntServletHolder(String name, Class<? extends Servlet> servlet) {
            super(name, servlet);
        }

        public AntServletHolder(String name, Servlet servlet) {
            super(name, servlet);
        }

        protected void initJspServlet() throws Exception {
            String classpath;
            ContextHandler ch = ((ContextHandler.Context)this.getServletHandler().getServletContext()).getContextHandler();
            ch.setAttribute("org.apache.catalina.jsp_classpath", (Object)ch.getClassPath());
            String sysClassPath = this.getSystemClassPath(ch.getClassLoader().getParent());
            this.setInitParameter("com.sun.appserv.jsp.classpath", sysClassPath);
            if ("?".equals(this.getInitParameter("classpath")) && (classpath = ch.getClassPath()) != null) {
                this.setInitParameter("classpath", classpath);
            }
        }

        protected String getSystemClassPath(ClassLoader loader) throws Exception {
            StringBuilder classpath = new StringBuilder();
            while (loader != null) {
                if (loader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)loader).getURLs();
                    if (urls != null) {
                        for (int i = 0; i < urls.length; ++i) {
                            Resource resource = Resource.newResource((URL)urls[i]);
                            File file = resource.getFile();
                            if (file == null || !file.exists()) continue;
                            if (classpath.length() > 0) {
                                classpath.append(File.pathSeparatorChar);
                            }
                            classpath.append(file.getAbsolutePath());
                        }
                    }
                } else if (loader instanceof AntClassLoader) {
                    classpath.append(((AntClassLoader)loader).getClasspath());
                }
                loader = loader.getParent();
            }
            return classpath.toString();
        }
    }
}

