/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.ant.JettyRunTask;
import org.eclipse.jetty.ant.WebApplicationProxyImpl;
import org.eclipse.jetty.ant.types.Connector;
import org.eclipse.jetty.ant.utils.ServerProxy;
import org.eclipse.jetty.ant.utils.TaskLog;
import org.eclipse.jetty.ant.utils.WebApplicationProxy;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.xml.sax.SAXException;

public class ServerProxyImpl
implements ServerProxy {
    private Server server;
    private ContextHandlerCollection contexts;
    private File jettyXml;
    private List connectors;
    private RequestLog requestLog;
    private List loginServices;
    private Map webApplications = new HashMap();

    public ServerProxyImpl(List connectors, List loginServicesList, RequestLog requestLog, File jettyXml) {
        this.server = new Server();
        this.server.setStopAtShutdown(true);
        this.connectors = connectors;
        this.loginServices = loginServicesList;
        this.requestLog = requestLog;
        this.jettyXml = jettyXml;
        this.configure();
    }

    @Override
    public void addWebApplication(WebApplicationProxy webApp, int scanIntervalSeconds) {
        webApp.createApplicationContext(this.contexts);
        if (scanIntervalSeconds > 0) {
            this.webApplications.put(webApp, new Integer(scanIntervalSeconds));
        }
    }

    private void configure() {
        this.applyJettyXml();
        for (Connector jettyConnector : this.connectors) {
            ServerConnector jc = new ServerConnector(this.server);
            jc.setPort(jettyConnector.getPort());
            jc.setIdleTimeout((long)jettyConnector.getMaxIdleTime());
            this.server.addConnector((org.eclipse.jetty.server.Connector)jc);
        }
        for (LoginService service : this.loginServices) {
            this.server.addBean((Object)service);
        }
        Resource.setDefaultUseCaches((boolean)false);
        this.configureHandlers();
    }

    private void configureHandlers() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        if (this.requestLog != null) {
            requestLogHandler.setRequestLog(this.requestLog);
        }
        this.contexts = (ContextHandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (this.contexts == null) {
            this.contexts = new ContextHandlerCollection();
            HandlerCollection handlers = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
            if (handlers == null) {
                handlers = new HandlerCollection();
                this.server.setHandler((Handler)handlers);
                handlers.setHandlers(new Handler[]{this.contexts, new DefaultHandler(), requestLogHandler});
            } else {
                handlers.addHandler((Handler)this.contexts);
            }
        }
    }

    private void applyJettyXml() {
        if (this.jettyXml != null && this.jettyXml.exists()) {
            TaskLog.log("Configuring jetty from xml configuration file = " + this.jettyXml.getAbsolutePath());
            try {
                XmlConfiguration configuration = new XmlConfiguration(Resource.toURL((File)this.jettyXml));
                configuration.configure((Object)this.server);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void start() {
        try {
            this.server.start();
            TaskLog.log("" + this.server.getConnectors()[0]);
            this.startScanners();
            this.server.join();
        }
        catch (InterruptedException e) {
            new RuntimeException(e);
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
    }

    private void startScanners() throws Exception {
        for (WebApplicationProxyImpl webApp : this.webApplications.keySet()) {
            Integer scanIntervalSeconds = (Integer)this.webApplications.get(webApp);
            JettyRunTask.startScanner(webApp, scanIntervalSeconds);
        }
    }

    @Override
    public Object getProxiedObject() {
        return this.server;
    }
}

