/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.eclipse.jetty.ant.ServerProxyImpl;
import org.eclipse.jetty.ant.WebApplicationProxyImpl;
import org.eclipse.jetty.ant.types.Connector;
import org.eclipse.jetty.ant.types.Connectors;
import org.eclipse.jetty.ant.types.LoginServices;
import org.eclipse.jetty.ant.types.SystemProperties;
import org.eclipse.jetty.ant.types.WebApp;
import org.eclipse.jetty.ant.utils.TaskLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.util.Scanner;

public class JettyRunTask
extends Task {
    private File tempDirectory;
    private List webapps = new ArrayList();
    private File jettyXml;
    private Connectors connectors = null;
    private RequestLog requestLog;
    private LoginServices loginServices;
    private SystemProperties systemProperties;
    private int jettyPort = 8080;

    public JettyRunTask() {
        TaskLog.setTask(this);
    }

    public void addWebApp(WebApp webapp) {
        this.webapps.add(webapp);
    }

    public void addConnectors(Connectors connectors) {
        if (this.connectors != null) {
            throw new BuildException("Only one <connectors> tag is allowed!");
        }
        this.connectors = connectors;
    }

    public void addUserRealms(Object o) {
        TaskLog.log("User realms are deprecated.");
    }

    public void addLoginServices(LoginServices services) {
        if (this.loginServices != null) {
            throw new BuildException("Only one <loginServices> tag is allowed!");
        }
        this.loginServices = services;
    }

    public void addSystemProperties(SystemProperties systemProperties) {
        if (this.systemProperties != null) {
            throw new BuildException("Only one <systemProperties> tag is allowed!");
        }
        this.systemProperties = systemProperties;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public File getJettyXml() {
        return this.jettyXml;
    }

    public void setJettyXml(File jettyXml) {
        this.jettyXml = jettyXml;
    }

    public void setRequestLog(String className) {
        try {
            this.requestLog = (RequestLog)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new BuildException("Request logger instantiation exception: " + e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Request logger instantiation exception: " + e);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Unknown request logger class: " + className);
        }
    }

    public String getRequestLog() {
        if (this.requestLog != null) {
            return this.requestLog.getClass().getName();
        }
        return "";
    }

    public void setJettyPort(int jettyPort) {
        this.jettyPort = jettyPort;
    }

    public void execute() throws BuildException {
        TaskLog.log("Configuring Jetty for project: " + this.getProject().getName());
        WebApplicationProxyImpl.setBaseTempDirectory(this.tempDirectory);
        this.setSystemProperties();
        List<Connector> connectorsList = null;
        connectorsList = this.connectors != null ? this.connectors.getConnectors() : new Connectors(this.jettyPort, 30000).getDefaultConnectors();
        List loginServicesList = this.loginServices != null ? this.loginServices.getLoginServices() : new ArrayList();
        ServerProxyImpl server = new ServerProxyImpl(connectorsList, loginServicesList, this.requestLog, this.jettyXml);
        try {
            for (WebApp webAppConfiguration : this.webapps) {
                WebApplicationProxyImpl webApp = new WebApplicationProxyImpl(webAppConfiguration.getName());
                webApp.setSourceDirectory(webAppConfiguration.getWarFile());
                webApp.setContextPath(webAppConfiguration.getContextPath());
                webApp.setWebXml(webAppConfiguration.getWebXmlFile());
                webApp.setJettyEnvXml(webAppConfiguration.getJettyEnvXml());
                webApp.setClassPathFiles(webAppConfiguration.getClassPathFiles());
                webApp.setLibrariesConfiguration(webAppConfiguration.getLibrariesConfiguration());
                webApp.setExtraScanTargetsConfiguration(webAppConfiguration.getScanTargetsConfiguration());
                webApp.setContextHandlers(webAppConfiguration.getContextHandlers());
                webApp.setAttributes(webAppConfiguration.getAttributes());
                webApp.setWebDefaultXmlFile(webAppConfiguration.getWebDefaultXmlFile());
                server.addWebApplication(webApp, webAppConfiguration.getScanIntervalSeconds());
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        server.start();
    }

    static void startScanner(final WebApplicationProxyImpl webApp, int scanIntervalSeconds) throws Exception {
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(webApp.getWebXmlFile());
        scanList.addAll(webApp.getLibraries());
        scanList.addAll(webApp.getExtraScanTargets());
        Scanner.BulkListener changeListener = new Scanner.BulkListener(){

            public void filesChanged(List changedFiles) {
                if (this.hasAnyFileChanged(changedFiles)) {
                    try {
                        webApp.stop();
                        webApp.applyConfiguration();
                        webApp.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            private boolean hasAnyFileChanged(List changedFiles) {
                for (String className : changedFiles) {
                    if (!webApp.isFileScanned(className)) continue;
                    return true;
                }
                return false;
            }
        };
        TaskLog.log("Web application '" + webApp.getName() + "': starting scanner at interval of " + scanIntervalSeconds + " seconds.");
        Scanner scanner = new Scanner();
        scanner.setScanInterval(scanIntervalSeconds);
        scanner.addListener((Scanner.Listener)changeListener);
        scanner.setScanDirs(scanList);
        scanner.setReportExistingFilesOnStartup(false);
        scanner.start();
    }

    private void setSystemProperties() {
        if (this.systemProperties != null) {
            for (Property property : this.systemProperties.getSystemProperties()) {
                SystemProperties.setIfNotSetAlready(property);
            }
        }
    }
}

