/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.AntClassLoader;
import org.eclipse.jetty.util.PatternMatcher;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;

public class AntWebInfConfiguration
extends WebInfConfiguration {
    public void preConfigure(final WebAppContext context) throws Exception {
        File work = this.findWorkDirectory(context);
        if (work != null) {
            this.makeTempDirectory(work, context, false);
        }
        this.resolveTempDirectory(context);
        this.unpack(context);
        String tmp = (String)context.getAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern");
        Pattern webInfPattern = tmp == null ? null : Pattern.compile(tmp);
        tmp = (String)context.getAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern");
        Pattern containerPattern = tmp == null ? null : Pattern.compile(tmp);
        PatternMatcher containerJarNameMatcher = new PatternMatcher(){

            public void matched(URI uri) throws Exception {
                context.getMetaData().addContainerJar(Resource.newResource((URI)uri));
            }
        };
        ClassLoader loader = context.getClassLoader();
        if (loader != null && (loader = loader.getParent()) != null) {
            AntClassLoader antLoader;
            String[] paths;
            URI[] containerUris = null;
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                if (urls != null) {
                    containerUris = new URI[urls.length];
                    int i = 0;
                    for (URL u : urls) {
                        try {
                            containerUris[i] = u.toURI();
                        }
                        catch (URISyntaxException e) {
                            containerUris[i] = new URI(u.toString().replaceAll(" ", "%20"));
                        }
                        ++i;
                    }
                }
            } else if (loader instanceof AntClassLoader && (paths = (antLoader = (AntClassLoader)loader).getClasspath().split(new String(new char[]{File.pathSeparatorChar}))) != null) {
                containerUris = new URI[paths.length];
                int i = 0;
                for (String p : paths) {
                    File f = new File(p);
                    containerUris[i] = f.toURI();
                    ++i;
                }
            }
            containerJarNameMatcher.match(containerPattern, containerUris, false);
        }
        PatternMatcher webInfJarNameMatcher = new PatternMatcher(){

            public void matched(URI uri) throws Exception {
                context.getMetaData().addWebInfJar(Resource.newResource((URI)uri));
            }
        };
        List jars = this.findJars(context);
        URI[] uris = null;
        if (jars != null) {
            uris = new URI[jars.size()];
            int i = 0;
            for (Resource r : jars) {
                uris[i++] = r.getURI();
            }
        }
        webInfJarNameMatcher.match(webInfPattern, uris, true);
    }
}

