/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;

public class AntMetaInfConfiguration
extends MetaInfConfiguration {
    public Class<? extends Configuration> replaces() {
        return MetaInfConfiguration.class;
    }

    public void findAndFilterContainerPaths(WebAppContext context) throws Exception {
        super.findAndFilterContainerPaths(context);
    }

    protected List<URI> getAllContainerJars(WebAppContext context) throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (context.getClassLoader() != null) {
            for (ClassLoader loader = context.getClassLoader().getParent(); loader != null; loader = loader.getParent()) {
                if (loader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)loader).getURLs();
                    if (urls == null) continue;
                    for (URL url : urls) {
                        uris.add(new URI(url.toString().replaceAll(" ", "%20")));
                    }
                    continue;
                }
                if (!(loader instanceof AntClassLoader)) continue;
                AntClassLoader antLoader = (AntClassLoader)loader;
                String[] paths = antLoader.getClasspath().split(new String(new char[]{File.pathSeparatorChar}));
                if (paths == null) continue;
                for (String p : paths) {
                    File f = new File(p);
                    uris.add(f.toURI());
                }
            }
        }
        return uris;
    }
}

