/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Manifest;
import javax.servlet.Servlet;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.jetty.ant.AntMetaInfConfiguration;
import org.eclipse.jetty.ant.AntWebInfConfiguration;
import org.eclipse.jetty.ant.AntWebXmlConfiguration;
import org.eclipse.jetty.ant.types.Attribute;
import org.eclipse.jetty.ant.types.Attributes;
import org.eclipse.jetty.ant.types.FileMatchingConfiguration;
import org.eclipse.jetty.ant.utils.TaskLog;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntWebAppContext
extends WebAppContext {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppContext.class);
    public static final String DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN = ".*/.*jsp-api-[^/]*\\.jar$|.*/.*jsp-[^/]*\\.jar$|.*/.*taglibs[^/]*\\.jar$|.*/.*jstl[^/]*\\.jar$|.*/.*jsf-impl-[^/]*\\.jar$|.*/.*javax.faces-[^/]*\\.jar$|.*/.*myfaces-impl-[^/]*\\.jar$";
    private File jettyEnvXml;
    private List<FileSet> libraries = new ArrayList<FileSet>();
    private List<FileSet> classes = new ArrayList<FileSet>();
    private File contextXml;
    private FileSet scanTargets;
    private Attributes attributes;
    private Project project;
    private List<File> scanFiles;
    private FileMatchingConfiguration librariesConfiguration;

    public static void dump(ClassLoader loader) {
        while (loader != null) {
            URL[] urls;
            System.err.println(loader);
            if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()) != null) {
                for (URL u : urls) {
                    System.err.println("\t" + u + "\n");
                }
            }
            loader = loader.getParent();
        }
    }

    public AntWebAppContext(Project project) throws Exception {
        this.project = project;
        this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN);
        this.setParentLoaderPriority(true);
        this.addConfiguration(new Configuration[]{new AntWebInfConfiguration(), new AntWebXmlConfiguration(), new AntMetaInfConfiguration()});
    }

    public void addAttributes(Attributes atts) {
        if (this.attributes != null) {
            throw new BuildException("Only one <attributes> tag is allowed!");
        }
        this.attributes = atts;
    }

    public void addLib(FileSet lib) {
        this.libraries.add(lib);
    }

    public void addClasses(FileSet classes) {
        this.classes.add(classes);
    }

    protected ServletHandler newServletHandler() {
        return new AntServletHandler();
    }

    public void setJettyEnvXml(File jettyEnvXml) {
        this.jettyEnvXml = jettyEnvXml;
        TaskLog.log("jetty-env.xml file: = " + (jettyEnvXml == null ? null : jettyEnvXml.getAbsolutePath()));
    }

    public File getJettyEnvXml() {
        return this.jettyEnvXml;
    }

    public List<File> getLibraries() {
        return this.librariesConfiguration.getBaseDirectories();
    }

    public void addScanTargets(FileSet scanTargets) {
        if (this.scanTargets != null) {
            throw new BuildException("Only one <scanTargets> tag is allowed!");
        }
        this.scanTargets = scanTargets;
    }

    public List<File> getScanTargetFiles() {
        if (this.scanTargets == null) {
            return null;
        }
        FileMatchingConfiguration configuration = new FileMatchingConfiguration();
        configuration.addDirectoryScanner(this.scanTargets.getDirectoryScanner(this.project));
        return configuration.getBaseDirectories();
    }

    public List<File> getScanFiles() {
        if (this.scanFiles == null) {
            this.scanFiles = this.initScanFiles();
        }
        return this.scanFiles;
    }

    public boolean isScanned(File file) {
        List<File> files = this.getScanFiles();
        if (files == null || files.isEmpty()) {
            return false;
        }
        return files.contains(file);
    }

    public List<File> initScanFiles() {
        List<File> scanFiles;
        List<File> cpFiles;
        Resource r;
        ArrayList<File> scanList = new ArrayList<File>();
        if (this.getDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.getDescriptor());
                try {
                    scanList.add(r.getFile());
                }
                finally {
                    if (r != null) {
                        r.close();
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (this.getJettyEnvXml() != null) {
            try {
                r = Resource.newResource((File)this.getJettyEnvXml());
                try {
                    scanList.add(r.getFile());
                }
                finally {
                    if (r != null) {
                        r.close();
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException("Problem configuring scanner for jetty-env.xml", (Throwable)e);
            }
        }
        if (this.getDefaultsDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.getDefaultsDescriptor());
                try {
                    if (!"org/eclipse/jetty/webapp/webdefault.xml".equals(this.getDefaultsDescriptor())) {
                        scanList.add(r.getFile());
                    }
                }
                finally {
                    if (r != null) {
                        r.close();
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException("Problem configuring scanner for webdefaults.xml", (Throwable)e);
            }
        }
        if (this.getOverrideDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.getOverrideDescriptor());
                scanList.add(r.getFile());
            }
            catch (IOException e) {
                throw new BuildException("Problem configuring scanner for webdefaults.xml", (Throwable)e);
            }
        }
        if ((cpFiles = this.getClassPathFiles()) != null) {
            scanList.addAll(cpFiles);
        }
        if ((scanFiles = this.getScanTargetFiles()) != null) {
            scanList.addAll(scanFiles);
        }
        return scanList;
    }

    public void setWar(String path) {
        super.setWar(path);
        try {
            Resource war = Resource.newResource((String)path);
            if (war.exists() && war.isDirectory() && this.getDescriptor() == null) {
                Resource webXml = war.addPath("WEB-INF/web.xml");
                this.setDescriptor(webXml.toString());
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void doStart() {
        try {
            ClassLoader parentLoader;
            TaskLog.logWithTimestamp("Starting web application " + this.getDescriptor());
            if (this.jettyEnvXml != null && this.jettyEnvXml.exists()) {
                ((EnvConfiguration)this.getConfiguration(EnvConfiguration.class)).setJettyEnvResource((Resource)new PathResource(this.jettyEnvXml));
            }
            if ((parentLoader = ((Object)((Object)this)).getClass().getClassLoader()) instanceof AntClassLoader) {
                parentLoader = new AntURLClassLoader((AntClassLoader)parentLoader);
            }
            this.setClassLoader((ClassLoader)new WebAppClassLoader(parentLoader, (WebAppClassLoader.Context)this));
            if (this.attributes != null && this.attributes.getAttributes() != null) {
                for (Attribute a : this.attributes.getAttributes()) {
                    this.setAttribute(a.getName(), a.getValue());
                }
            }
            if (this.contextXml != null) {
                XmlConfiguration xmlConfiguration = new XmlConfiguration((Resource)new PathResource(this.contextXml));
                TaskLog.log("Applying context xml file " + this.contextXml);
                xmlConfiguration.configure((Object)this);
            }
            super.doStart();
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    public void doStop() {
        try {
            this.scanFiles = null;
            TaskLog.logWithTimestamp("Stopping web application " + this);
            Thread.currentThread();
            Thread.sleep(500L);
            super.doStop();
            this.getServletHandler().setFilters(new FilterHolder[0]);
            this.getServletHandler().setFilterMappings(new FilterMapping[0]);
            this.getServletHandler().setServlets(new ServletHolder[0]);
            this.getServletHandler().setServletMappings(new ServletMapping[0]);
        }
        catch (InterruptedException e) {
            TaskLog.log(e.toString());
        }
        catch (Exception e) {
            TaskLog.log(e.toString());
        }
    }

    public List<File> getClassPathFiles() {
        ArrayList<File> classPathFiles = new ArrayList<File>();
        for (FileSet clazz : this.classes) {
            classPathFiles.add(clazz.getDirectoryScanner(this.project).getBasedir());
        }
        for (FileSet library : this.libraries) {
            String[] includedFiles = library.getDirectoryScanner(this.project).getIncludedFiles();
            File baseDir = library.getDirectoryScanner(this.project).getBasedir();
            for (int i = 0; i < includedFiles.length; ++i) {
                classPathFiles.add(new File(baseDir, includedFiles[i]));
            }
        }
        return classPathFiles;
    }

    public FileMatchingConfiguration getLibrariesConfiguration() {
        FileMatchingConfiguration config = new FileMatchingConfiguration();
        for (FileSet clazz : this.classes) {
            config.addDirectoryScanner(clazz.getDirectoryScanner(this.project));
        }
        for (FileSet library : this.libraries) {
            config.addDirectoryScanner(library.getDirectoryScanner(this.project));
        }
        return config;
    }

    public File getContextXml() {
        return this.contextXml;
    }

    public void setContextXml(File contextXml) {
        this.contextXml = contextXml;
    }

    public static class AntServletHandler
    extends ServletHandler {
        public ServletHolder newServletHolder(Source source) {
            return new AntServletHolder();
        }
    }

    public static class AntURLClassLoader
    extends URLClassLoader {
        private AntClassLoader antLoader;

        public AntURLClassLoader(AntClassLoader antLoader) {
            super(new URL[0], (ClassLoader)antLoader);
            this.antLoader = antLoader;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return super.getResourceAsStream(name);
        }

        @Override
        public void close() throws IOException {
            super.close();
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        public URL[] getURLs() {
            URL[] ourURLS;
            HashSet<URL> urls = new HashSet<URL>();
            String[] paths = this.antLoader.getClasspath().split(new String(new char[]{File.pathSeparatorChar}));
            if (paths != null) {
                for (String p : paths) {
                    File f = new File(p);
                    try {
                        urls.add(f.toURI().toURL());
                    }
                    catch (Exception e) {
                        LOG.trace("IGNORED", (Throwable)e);
                    }
                }
            }
            if ((ourURLS = super.getURLs()) != null) {
                for (URL u : ourURLS) {
                    urls.add(u);
                }
            }
            return urls.toArray(new URL[urls.size()]);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        @Override
        public URL findResource(String name) {
            return super.findResource(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            return super.findResources(name);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            return super.getPermissions(codesource);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return super.loadClass(name);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }

        @Override
        protected Object getClassLoadingLock(String className) {
            return super.getClassLoadingLock(className);
        }

        @Override
        public URL getResource(String name) {
            return super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return super.getResources(name);
        }

        @Override
        protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
            return super.definePackage(name, man, url);
        }

        @Override
        protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
            return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }

        @Override
        protected Package[] getPackages() {
            return super.getPackages();
        }

        @Override
        protected String findLibrary(String libname) {
            return super.findLibrary(libname);
        }

        @Override
        public void setDefaultAssertionStatus(boolean enabled) {
            super.setDefaultAssertionStatus(enabled);
        }

        @Override
        public void setPackageAssertionStatus(String packageName, boolean enabled) {
            super.setPackageAssertionStatus(packageName, enabled);
        }

        @Override
        public void setClassAssertionStatus(String className, boolean enabled) {
            super.setClassAssertionStatus(className, enabled);
        }

        @Override
        public void clearAssertionStatus() {
            super.clearAssertionStatus();
        }
    }

    public static class AntServletHolder
    extends ServletHolder {
        public AntServletHolder() {
        }

        public AntServletHolder(Class<? extends Servlet> servlet) {
            super(servlet);
        }

        public AntServletHolder(Servlet servlet) {
            super(servlet);
        }

        public AntServletHolder(String name, Class<? extends Servlet> servlet) {
            super(name, servlet);
        }

        public AntServletHolder(String name, Servlet servlet) {
            super(name, servlet);
        }

        protected String getSystemClassPath(ClassLoader loader) throws Exception {
            StringBuilder classpath = new StringBuilder();
            while (loader != null) {
                if (loader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)loader).getURLs();
                    if (urls != null) {
                        for (int i = 0; i < urls.length; ++i) {
                            Resource resource = Resource.newResource((URL)urls[i]);
                            File file = resource.getFile();
                            if (file == null || !file.exists()) continue;
                            if (classpath.length() > 0) {
                                classpath.append(File.pathSeparatorChar);
                            }
                            classpath.append(file.getAbsolutePath());
                        }
                    }
                } else if (loader instanceof AntClassLoader) {
                    classpath.append(((AntClassLoader)loader).getClasspath());
                }
                loader = loader.getParent();
            }
            return classpath.toString();
        }
    }
}

