/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jetty.ant.utils.TaskLog;

public class JettyStopTask
extends Task {
    private int stopPort;
    private String stopKey;
    private int stopWait;

    public JettyStopTask() {
        TaskLog.setTask(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), this.stopPort);
            if (this.stopWait > 0) {
                s.setSoTimeout(this.stopWait * 1000);
            }
            try {
                OutputStream out = s.getOutputStream();
                out.write((this.stopKey + "\r\nstop\r\n").getBytes());
                out.flush();
                if (this.stopWait > 0) {
                    TaskLog.log("Waiting" + (String)(this.stopWait > 0 ? " " + this.stopWait + "sec" : "") + " for jetty to stop");
                    LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                    String response = lin.readLine();
                    if ("Stopped".equals(response)) {
                        System.err.println("Stopped");
                    }
                }
            }
            finally {
                s.close();
            }
        }
        catch (ConnectException e) {
            TaskLog.log("Jetty not running!");
        }
        catch (Exception e) {
            TaskLog.log(e.getMessage());
        }
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
    }

    public int getStopWait() {
        return this.stopWait;
    }

    public void setStopWait(int stopWait) {
        this.stopWait = stopWait;
    }
}

